using System;
using Server;
using System.Collections;
using System.Collections.Generic;
using Server.Gumps;
using Server.Network;
using Server.Mobiles;

namespace Server.Items
{
	public class KhalAnkurAmulet : BaseTalisman
	{
      public override bool ForceShowName{ get{ return true; } }
      
		private int m_SpendingPoints;
		private int m_OrbRange;
		private int m_OrbBonus;
		private int m_PotionTime;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int SpendingPoints { get { return m_SpendingPoints; } set { m_SpendingPoints = value; InvalidateProperties(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int OrbRange{ get{ return m_OrbRange; } set{ m_OrbRange = value; InvalidateProperties(); } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int OrbBonus{ get{ return m_OrbBonus; } set{ m_OrbBonus = value; InvalidateProperties(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int PotionTime{ get{ return m_PotionTime; } set{ m_PotionTime = value; InvalidateProperties(); } }
		
		//public bool IsMaxed{ get{ return ( m_OrbRange > 1 && m_OrbBonus > 9 && m_PotionTime > 29 ); } }
      
		[Constructable]
		public KhalAnkurAmulet() : base( 0x2F5A )
		{
			Hue = 853; //Utility.RandomNeutralHue();
			Name = "<basefont color=#669999>Khal Ankur Amulet";
			
			Blessed = false;
			MaxChargeTime = 1000;
			MaxCharges = 20;
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( GreaterHealPotion ), 1, 1073467 );
			
			Protection = new TalismanAttribute( typeof( KhaldunSummoner ), 30, 1072449 );
			Killer = new TalismanAttribute( typeof( KhaldunZealot ), Utility.RandomMinMax( 20, 40 ), "Khaldun Zealot" );
         Slayer = TalismanSlayerName.Mage;
						
			Skill = SkillName.Cartography;
			SuccessBonus = Utility.RandomMinMax( 15, 30 );
			
			SkillBonuses.SetValues( 2, SkillName.Anatomy, 15.0 );
			SkillBonuses.SetValues( 3, SkillName.EvalInt, 15.0 );
			Attributes.Luck = 150;
			Attributes.BonusHits = 20;
			Attributes.AttackChance = 30;
			Attributes.DefendChance = 10;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#669999>Corrupt body damage: -50%" );
 			list.Add( 1060658, "Healing orbs pickup range\t+{0}/2", m_OrbRange );
 			list.Add( 1060659, "Healing orbs bonus\t+{0}/10%", m_OrbBonus );
 			list.Add( 1060660, "Khaldun potion delay decrease\t{0}/30 sec", m_PotionTime );
 			list.Add( 1060661, "Spending points\t{0}<basefont color=White>", m_SpendingPoints );
		}
		
		public override void OnDoubleClick( Mobile from )
		{
         if ( this.IsChildOf( from.Backpack ) )
         {
				if( from.HasGump( typeof(PrivateGump) ) )
					from.CloseGump( typeof(PrivateGump) );
						
				from.SendGump( new PrivateGump( this ) );
         }
         else
            base.OnDoubleClick( from );
		}
		
		private class PrivateGump : Gump
		{
			private KhalAnkurAmulet amu;
			
			public PrivateGump( KhalAnkurAmulet a ) : base(200, 200)
			{
				amu = a;
				
				if ( amu == null ) return;
				
				this.Closable=true;
				this.Disposable=true;
				this.Dragable=true;
				this.Resizable=false;
				
				this.AddPage(0);
            this.AddBackground(0, 0, 321, 190, 9200);
            this.AddBackground(3, 3, 315, 50, 3500);
            this.AddLabel(25, 19, 152, String.Format( "Khal Ankur Amulet: {0} Spending points", amu.SpendingPoints ));
            this.AddBackground(3, 52, 315, 135, 3500);
            
            this.AddLabel(20, 70, 0, String.Format( "Healing orbs pickup range: +{0}/2", amu.OrbRange ));
            
            if ( amu.SpendingPoints > 19 && amu.OrbRange < 2 )
               this.AddButton(245, 70, 9903, 9904, (int)Buttons.OrbRange, GumpButtonType.Reply, 0);
               
            this.AddLabel(270, 70, 0, @"20b");
            
            this.AddLabel(20, 95, 0, String.Format( "Healing orbs bonus: {0}/10%", amu.OrbBonus ));
            
            if ( amu.SpendingPoints > 2 && amu.OrbBonus < 10 )
               this.AddButton(245, 95, 9903, 9904, (int)Buttons.OrbBonus, GumpButtonType.Reply, 0);
               
            this.AddLabel(270, 95, 0, @"3b");
            
            this.AddLabel(20, 120, 0, String.Format( "Khaldun potion delay: {0}/30sec", amu.PotionTime ));
            
            if ( amu.SpendingPoints > 0 && amu.PotionTime < 30 )
               this.AddButton(245, 120, 9903, 9904, (int)Buttons.PotionTime, GumpButtonType.Reply, 0);
               
            this.AddLabel(270, 120, 0, @"1b");
            
            this.AddLabel(20, 145, 0, @"Artifact fragment");
            
            if ( amu.SpendingPoints > 0 )
               this.AddButton(245, 145, 9903, 9904, (int)Buttons.Fragment, GumpButtonType.Reply, 0);
               
            this.AddLabel(270, 145, 0, @"1b");
			}
			
			public enum Buttons
			{
				Close,
            OrbRange,
            OrbBonus,
				PotionTime,
				Fragment
			}
			
			public override void OnResponse( NetState sender, RelayInfo info )
			{
				Mobile from = sender.Mobile;
				
				if ( from == null || amu == null || amu.Deleted )
					return;
				else if ( !amu.IsChildOf( from.Backpack ) )
				{
					from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
					
					if( from.HasGump( typeof(PrivateGump) ) )
						from.CloseGump( typeof(PrivateGump) );
					
					return;
				}
				
				switch( info.ButtonID )
				{
					case (int)Buttons.Close:
						{
							return;
                     break;
						}
               case (int)Buttons.OrbRange:
						{
							if ( amu.SpendingPoints > 19 && amu.OrbRange < 2 )
							{
								amu.OrbRange++;
								amu.SpendingPoints -= 20;
							}
							break;
						}
					case (int)Buttons.OrbBonus:
						{
							if ( amu.SpendingPoints > 2 && amu.OrbBonus < 10 )
							{
								amu.OrbBonus++;
								amu.SpendingPoints -= 3;
							}
							break;
						}
					case (int)Buttons.PotionTime:
						{
							if ( amu.SpendingPoints > 0 && amu.PotionTime < 30 )
							{
								amu.PotionTime++;
								amu.SpendingPoints--;
							}
							break;
						}
					case (int)Buttons.Fragment:
						{
							if ( amu.SpendingPoints > 0 )
							{
								from.AddToBackpack( new ArtifactFragment() );
								amu.SpendingPoints--;
							}
							break;
						}
				}
				
				from.PlaySound( 81 );
				from.SendGump( new PrivateGump( amu ) );
			}
		}

		public KhalAnkurAmulet( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
			
			writer.Write( (int) m_SpendingPoints);
			writer.Write( (int) m_OrbRange);
			writer.Write( (int) m_OrbBonus);
			writer.Write( (int) m_PotionTime);
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
					{
						goto case 0;
					}
				case 0:
					{
						m_SpendingPoints = reader.ReadInt();
						m_OrbRange = reader.ReadInt();
						m_OrbBonus = reader.ReadInt();
						m_PotionTime = reader.ReadInt();
						break;
					}
			}
		}
	}
}