using System;

namespace Server.Items
{
	public class SwaddlingClothes : Hakama
	{
		public override int ArtifactRarity{ get{ return 45; } }
		public override int BaseColdResistance{ get{ return 10; } }
		public override int BasePhysicalResistance{ get{ return 5; } }
		
      [Constructable]
		public SwaddlingClothes() : base()
		{
			Name = "<basefont color=#6633FF>Swaddling Clothes";
			Hue = 2037;
			
			SkillBonuses.SetValues( 0, SkillName.RemoveTrap, 5 );
			SkillBonuses.SetValues( 1, SkillName.Focus, 5 );

			this.Attributes.AttackChance = 10;
			this.Attributes.BonusDex = 5;
			this.Attributes.BonusInt = 5;
			this.Attributes.BonusStr = 5;
			this.Attributes.LowerRegCost = 5;
			this.Attributes.Luck = 50;
			this.Attributes.RegenHits = 3;
			this.Attributes.WeaponDamage = 10;
			this.Attributes.SpellDamage = 10;
			this.Attributes.BonusHits = 10;
			this.Attributes.BonusMana = 10;
			
			LootType = LootType.Cursed;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#6633FF>Chance to drop healing cloud on flamestrike<basefont color=White>" );
		}

		public SwaddlingClothes( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}