using System;
using Server;
using Server.Network;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class HealingCloud : HealthOrb
	{
		[Constructable]
		public HealingCloud() :  base()
		{
			Movable = false;
			Hue = 2648;
			ItemID = 14120;
			Name = "healing cloud";
			
// 			Timer.DelayCall( TimeSpan.FromSeconds( 30.0 ), new TimerCallback( Morph ) );
		}
		
		private void Morph()
		{
			if ( this.Deleted )
				return;
			
			Hue = 2548;
			Effects.PlaySound( Location, Map, 553 );
		}
		
		public override void Heal( Mobile m )
		{
			if ( this.Deleted || m == null )
				return;
			
			m.RevealingAction();
			m.FixedParticles( 0x376A, 9, 32, 5005, EffectLayer.Waist );
			m.PlaySound( 0x1F2 );
				
			m.Heal( Server.Engines.XmlSpawner2.XmlSpecial.PercentualDamage( 20 + Server.Regions.KhaldunRegion.Talisman( m, 3 ), m ) );
			m.Mana += (int) 0.1 * m.ManaMax;
			m.Stam += (int) 0.1 * m.StamMax;

			this.Delete();
		}
		
		public override void OnDelete()
		{
         base.OnDelete();
		}

		public HealingCloud( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			this.Delete();
		}
	}
}
