using System;
using Server;
using Server.Network;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class HealthOrb : SelfDeletingItem
	{
		[Constructable]
		public HealthOrb() :  base( 14265, "health orb", 50 )
		{
			Movable = false;
			Hue = 2447;
			
			Timer.DelayCall( TimeSpan.FromSeconds( 30.0 ), new TimerCallback( Morph ) );
		}
		
		private void Morph()
		{
			if ( this.Deleted )
				return;
			
			ItemID = 14270;
			Hue = 2435;
			Effects.PlaySound( Location, Map, 553 );
		}
		
		public override bool HandlesOnMovement{ get{ return true; } }

		public override void OnMovement( Mobile from, Point3D oldLocation )
		{
			if ( from.Player && from.AccessLevel == AccessLevel.Player && !from.Hidden && from.Alive && !from.Blessed && from.GetDistanceToSqrt( this ) <= ( 1 + Server.Regions.KhaldunRegion.Talisman( from, 2 ) ) )
            Heal( from );
			
			base.OnMovement( from, oldLocation );
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !from.Player || from.AccessLevel > AccessLevel.Player || from.Hidden  || !from.Alive  || from.Blessed )
				return;

			if ( !from.InRange( this.GetWorldLocation(), 1 + Server.Regions.KhaldunRegion.Talisman( from, 2 ) ) )
				from.SendLocalizedMessage( 502138 );
			else
				Heal( from );
		}
		
		public virtual void Heal( Mobile from )
		{
			if ( this.Deleted || from == null )
				return;
				
			if ( from.Hits >= from.HitsMax )
			{
            HealingCloudJug jug = ( from.Backpack == null ? null : from.Backpack.FindItemByType( typeof( HealingCloudJug ) ) as HealingCloudJug );
            
            if ( jug != null && jug.Clouds < 5 && jug.Charges > 1 )
            {
               jug.Clouds++;
               jug.Charges--;
               from.SendMessage("jug of healing clouds absorboval health orb");
            }
         }
			
			ArrayList targets = new ArrayList();
			
			foreach ( Mobile m in this.GetMobilesInRange( 3 + Server.Regions.KhaldunRegion.Talisman( from, 2 ) ) )
			{
				if (m == null || m.Deleted)
					continue;
				
				if (m is BaseCreature && (((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned))
				{
					if (!m.IsDeadBondedPet && m.Alive && !m.Blessed && m.InLOS(this))
						targets.Add(m);
				}
				else if (m.Player && !m.Blessed && m.AccessLevel == AccessLevel.Player && m.Alive && m.InLOS(this))
					targets.Add(m);
			}
			
			for (int i = 0; i < targets.Count; ++i)
			{
				Mobile m = (Mobile)targets[i];
				
				if ( m == null || m.Deleted )
					continue;
				
				m.RevealingAction();
				m.FixedParticles( 0x376A, 9, 32, 5005, EffectLayer.Waist );
				m.PlaySound( 0x1F2 );
				//             Effects.SendMovingEffect(this, m, 0x36D4, 5, 0, false, false);
				
				m.Heal( Server.Engines.XmlSpawner2.XmlSpecial.PercentualDamage( 20 + Server.Regions.KhaldunRegion.Talisman( m, 3 ), m ) );
				m.Mana += (int) 0.2 * m.ManaMax;
				m.Stam += (int) 0.2 * m.StamMax;
			}
			
			Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x374A, 9, 32, 5024 );
			Effects.PlaySound( Location, Map, 0x5C9 );
			this.Delete();
		}
		
		public override void OnDelete()
		{
			Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x374A, 9, 32, 5024 );
         base.OnDelete();
		}

		public HealthOrb( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			this.Delete();
		}
	}
}
