using Server.Items;
using Server.Mobiles;
using Server.Spells.Chivalry;
using Server.Spells.First;
using Server.Spells.Fourth;
using Server.Spells.Second;
using Server.Spells.Seventh;
using Server.Spells.Sixth;
using Server.Spells.Third;
using System.Xml;


namespace Server.Regions
{
    public class KhaldunRegion : DungeonRegion
    {
        public KhaldunRegion(XmlElement xml, Map map, Region parent) : base(xml, map, parent)
        {
        }

        // 		public static int RandomFireHue { get { return Utility.RandomList( 1092, 1066, 1059, 1068, 1078, 1161, 1198, 1259, 1360, 1932,
        //          2019, 2020, 2021, 2162, 2163, 2449, 2454, 2487, 2640, 2622 ); } }

        public override bool OnBeginSpellCast(Mobile m, ISpell s)
        {
            if (m.AccessLevel > AccessLevel.Player || !m.Player /* || ((Spell)s).Scroll != null */ )
                return base.OnBeginSpellCast(m, s);

            if (s is GateTravelSpell || s is RecallSpell || s is MarkSpell || s is CloseWoundsSpell || s is EtherealMount.EtherealSpell || s is Server.Spells.Necromancy.TransformationSpell ||
                s is Server.Spells.Spellweaving.GiftOfLifeSpell || s is Server.Spells.Spellweaving.GiftOfRenewalSpell || s is HealSpell || s is GreaterHealSpell ||
                s is Server.Spells.Spellweaving.NatureFurySpell || s is Server.Spells.Ninjitsu.NinjaSpell || s is Server.Spells.SamuraiMove || s is Server.Spells.Bushido.SamuraiSpell ||
                s is TeleportSpell || s is Server.Spells.NinjaMove || s is MagicTrapSpell || s is PolymorphSpell || s is MagicLockSpell)
            {
                m.SendLocalizedMessage(501802); // Thy spell doth not appear to work...
                return false;
            }

            return base.OnBeginSpellCast(m, s);
        }

        public override bool AllowHousing(Mobile from, Point3D p)
        {
            return false;
        }

        public override bool CanUseStuckMenu(Mobile m)
        {
            return true;
        }

        /*public override bool OnResurrect( Mobile m )
		{
			if ( m.AccessLevel == AccessLevel.Player )
			{
				m.SendMessage("Zde nelze ozivovat");
				return false;
			}

			return true;
		}*/

        public override bool OnDoubleClick(Mobile m, object o)
        {
            if (m.AccessLevel > AccessLevel.Player)
                return base.OnDoubleClick(m, o);

            if ( /*o is GreaterHealPotion || */o is SuperPotion || o is EtherealMount || o is TotalManaRefreshPotion || o is BankCrystal || o is Bandage || o is EnhancedBandage)
            {
                m.SendMessage("Tento predmet zde nemuzes pouzit.");
                return false;
            }
            else if (o is Xanthos.Interfaces.IShrinkItem)
            {
                BaseCreature bc = (BaseCreature)((Xanthos.Interfaces.IShrinkItem)o).ShrunkenPet;

                if (bc != null && bc.IsBonded)
                {
                    m.SendMessage("Zde nemuzes odshrinknout bondle pety.");
                    return false;
                }
            }
            /*else if ( o is GreaterHealPotion )
			{
				if ( !m.BeginAction( typeof( BasePotion ) ) )
				{
					m.SendMessage( "Jeste nemuzes lektvar pouzit." );
					return false;
				}
				else
					Timer.DelayCall( TimeSpan.FromSeconds( 120 - Talisman( m, 4 ) ), new TimerStateCallback( ReleasePotionLock ), m );
				
				BaseMount.Dismount( m );
			}*/
            else if (o is BaseMount)
            {
                m.SendLocalizedMessage(1042317, "", 0x41); // You may not ride at this time
                return false;
            }

            BaseMount.Dismount(m);

            return base.OnDoubleClick(m, o);
        }

        /*public override bool AllowBeneficial(Mobile from, Mobile target)
		{
			if ( ( from is BaseCreature && !((BaseCreature)from).Controlled ) || from.AccessLevel > AccessLevel.Player )
				return base.AllowBeneficial(from, target);

			from.SendMessage("You cannot perform benificial acts on your target.");
			return false;
		}*/

        public override bool OnSkillUse(Mobile from, int Skill)
        {
            if (from.AccessLevel == AccessLevel.Player)
            {
                if (Skill == ((int)SkillName.Healing) || Skill == ((int)SkillName.SpiritSpeak))
                {
                    from.SendMessage("Tento skill lze nelze pouzit");
                    return false;
                }
            }

            return base.OnSkillUse(from, Skill);
        }

        // 		private static void ReleasePotionLock( object state )
        // 		{
        // 			((Mobile)state).EndAction( typeof( BasePotion ) );
        // 		}

        /*		public override void OnGotHarmful( Mobile harmer, Mobile harmed )
                {
                    if ( harmer.Player && ( harmed is BaseCreature && !( harmed is BaseSummoned ) ) )
                    {
                        if ( !((BaseCreature)harmed).Controlled && Utility.RandomDouble() < 0.007 ) //Sance na drop health orbu
                        {
                            DropHealthOrb( harmed );
                        }
                    }

                    base.OnGotHarmful( harmer, harmed );
                }
        */
        public static void DropHealthOrb(Mobile harmed)
        {
            bool validLocation = false;
            Point3D loc = harmed.Location;

            for (int j = 0; !validLocation && j < 10; ++j)
            {
                int x = harmed.X + Utility.Random(4);
                int y = harmed.Y + Utility.Random(4);
                int z = harmed.Map.GetAverageZ(x, y);

                if (validLocation = (harmed.Map.CanFit(x, y, harmed.Z, 6, false, false) && harmed.InLOS(new Point3D(x, y, harmed.Z))))
                    loc = new Point3D(x, y, harmed.Z);
                else if (validLocation = (harmed.Map.CanFit(x, y, z, 6, false, false) && harmed.InLOS(new Point3D(x, y, z))))
                    loc = new Point3D(x, y, z);
            }

            if (!validLocation)
                return;

            //                   HealthOrb orb = new HealthOrb();
            new HealthOrb().MoveToWorld(loc, harmed.Map);
        }

        public override bool OnDamage(Mobile from, ref int Damage)
        {

            // 			if ( from.AccessLevel == AccessLevel.Player && PlayerRole( from ) == RoleType.Tank )
            // 				Damage -= (int) ( Damage * 0.3 );

            if (from is BaseCreature)
            {
                BaseCreature bc = (BaseCreature)from;

                if (bc.IsBonded)
                {
                    from.Kill();
                    return false;
                }
                else if (bc.Controlled && !bc.Summoned) //30% dmg pro ovladane nesummony
                    Damage -= (int)(Damage * 0.2);
            }

            return base.OnDamage(from, ref Damage);
        }

        public override bool OnDeath(Mobile m)
        {
            if (m is BaseCreature && Utility.RandomDouble() < 0.01)
            {
                BaseCreature bc = (BaseCreature)m;

                if (!bc.Controlled && bc.FightMode != FightMode.Aggressor && bc.Fame > 20000)
                {
                    //bc.PackItem( new PSToken() );
                    if (Utility.RandomDouble() < 0.2)
                    {
                        if (Utility.RandomDouble() < 0.3)
                            bc.PackItem(new ManaPotion());
                        else
                            bc.PackItem(new HealPotion());
                    }
                }
            }

            return base.OnDeath(m);
        }

        public static int Talisman(Mobile m, int abi)
        {
            KhalAnkurAmulet tal = m.FindItemOnLayer(Layer.Talisman) as KhalAnkurAmulet;

            if (tal == null)
                return 0;

            switch (abi)
            {
                case 1: //kontrola jestli je nasazen talisman
                    return 1;
                    break;

                case 2: //orb range
                    return tal.OrbRange;
                    break;

                case 3: //orb bonus
                    return tal.OrbBonus;
                    break;

                case 4: //PotionTime
                    return tal.PotionTime;
                    break;

                case 5: //SpendingPoints
                    return tal.SpendingPoints;
                    break;
            }

            return 1;
        }
    }
}
