using System;
using Server.Items;
using System.Collections;

namespace Server.Mobiles
{
	//[CorpseName( "an inhuman corpse" )]
	public class Cursed : BaseCreature
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Greater; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		[Constructable]
		public Cursed() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Title = "the Cursed";

			Hue = Utility.RandomMinMax(0x8596, 0x8599);
			Body = 0x190;
			Name = NameList.RandomName("male");
			BaseSoundID = 471;
			Utility.AssignRandomHair(this, true);

			AddItem(new ShortPants(Utility.RandomNeutralHue()));
			AddItem(new Shirt(Utility.RandomNeutralHue()));

			BaseWeapon weapon = Loot.RandomWeapon();
			weapon.Movable = false;
			AddItem(weapon);

			SetStr(600, 800);
			SetDex(220, 250);
			SetInt(266, 305);

			SetHits(1300, 1600);
			SetMana(2500);
			SetStam(1000);

			SetDamage(20, 25);

			SetDamageType(ResistanceType.Cold, 70);
			SetDamageType(ResistanceType.Physical, 15);
			SetDamageType(ResistanceType.Energy, 15);

			SetResistance(ResistanceType.Physical, 50, 70);
			SetResistance(ResistanceType.Fire, 50, 70);
			SetResistance(ResistanceType.Cold, 50, 70);
			SetResistance(ResistanceType.Poison, 50, 60);
			SetResistance(ResistanceType.Energy, 40, 70);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 90.1, 120.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 95.1);
			SetSkill(SkillName.Tactics, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Fencing, 90.0, 120.5);
			SetSkill(SkillName.Macing, 90.0, 120.5);
			SetSkill(SkillName.Swords, 90.0, 120.5);
			SetSkill(SkillName.Anatomy, 100.0);

			Fame = 1000;
			Karma = -2000;
		}

		private Timer m_Timer;

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			if (this.Hits < (this.HitsMax / 2))
			{
				if (m_Timer == null)
				{
					m_Timer = new InternalTimer(this);
					m_Timer.Start();
					this.PlaySound(this.Body.IsFemale ? 0x338 : 0x44A);
					this.PlaySound(654);
					this.FixedParticles(0x376A, 1, 31, 9961, 1160, 0, EffectLayer.Waist);
					this.FixedParticles(0x37C4, 1, 31, 9502, 43, 2, EffectLayer.Waist);
				}

				if (from is PlayerMobile && Utility.RandomDouble() < 0.3)
				{
					this.Location = TavaraSewel.GetSpawnPosition(from.Location, from.Map, 1);
					this.FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
					this.PlaySound(0x1FE);

					if (!from.Poisoned)
						Timer.DelayCall(TimeSpan.FromSeconds(1), new TimerCallback(delegate()
						{
							// poison
						                                                              	from.ApplyPoison(this, Poison.Deadly);
					from.FixedParticles(0x374A, 10, 15, 5021, EffectLayer.Waist);
					from.PlaySound(0x474);
				}

));
			}
		}

		if (from != null && 0.01 >= Utility.RandomDouble())
		{
			Ability.CriticalHit(from);
		}

		base.OnDamage(amount, from, willKill, typ);
	}

	public override bool OnBeforeDeath()
	{
		if (m_Timer != null)
			m_Timer.Stop();

			m_Timer = null;

			return base.OnBeforeDeath();
		}

		private class InternalTimer : Timer
		{
			private Cursed m_Owner;
			private int m_Count = 0;

			public InternalTimer(Cursed owner) : base(TimeSpan.FromSeconds(0.1), TimeSpan.FromSeconds(0.1))
			{
				m_Owner = owner;
				Priority = TimerPriority.TenMS;
			}

			protected override void OnTick()
			{
				if ((m_Count++ & 0x3) == 0)
				{
					m_Owner.Direction = (Direction)(Utility.Random(8) | 0x80);
				}

				m_Owner.Move(m_Owner.Direction);
			}
		}

		public override int GetAttackSound()
		{
			return -1;
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Rich);
			//AddLoot( LootPack.Miscellaneous );
		}

		public override void OnDelete()
		{
			if (m_Timer != null)
				m_Timer.Stop();

		m_Timer = null;

		base.OnDelete();
	}

	public override void OnKilledBy(Mobile mob)
	{
		base.OnKilledBy(mob);

		if (Paragon.CheckArtifactChance(mob, this) && mob.Talisman is KhalAnkurAmulet)
		{
			((KhalAnkurAmulet) mob.Talisman).SpendingPoints++;
		}
	}

	public override bool AlwaysMurderer { get { return true; } }

	public Cursed(Serial serial) : base(serial)
	{
	}

	public override void Serialize(GenericWriter writer)
	{
		base.Serialize(writer);

		writer.Write((int) 0); // version
	}

	public override void Deserialize(GenericReader reader)
	{
		base.Deserialize(reader);

		int version = reader.ReadInt();
	}
}
}