using System;
using Server.Items;
using Server.Network;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class GrimmochDrummel : BaseChampion
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool DeleteCorpseOnDeath { get { return true; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Deadly; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.ArmorIgnore;
				case 2: return WeaponAbility.ConcussionBlow;
			}
		}

		private bool m_FinalConfrontation = false;

		[Constructable]
		public GrimmochDrummel() : this (false, 3)
		{
		}

		[Constructable]
		public GrimmochDrummel(int range) : this (false, range)
		{
		}

		[Constructable]
		public GrimmochDrummel(bool ischampion, int range) : base(AIType.AI_Archer, FightMode.Closest, ischampion, range)
		{
			Title = "the Cursed";

			Hue = 0x8596;
			Body = 0x190;
			Name = "Grimmoch Drummel";

			HairItemID = 0x204A;	//Krisna

			DropMin = 50;
			DropMax = 100;
			BonusLoot = "tokens";
			BonusLootAmount = Utility.RandomMinMax(15, 30);

			Bow bow = new Bow();
			bow.Movable = false;
			bow.WeaponAttributes.HitFireball = 50;
			bow.WeaponAttributes.HitLeechHits = 40;
			bow.WeaponAttributes.HitLeechStam = 40;
			bow.WeaponAttributes.HitEnergyArea = 40;
			// 			bow.WeaponAttributes.HitLowerDefend = 100;
			bow.Attributes.AttackChance = 80;
			AddItem(bow);

			AddItem(new Boots(0x8A4));
			AddItem(new BodySash(0x8A4));

			Backpack backpack = new Backpack();
			backpack.Movable = false;
			AddItem(backpack);

			LeatherGloves gloves = new LeatherGloves();
			LeatherChest chest = new LeatherChest();
			gloves.Hue = 0x96F;
			chest.Hue = 0x96F;

			AddItem(gloves);
			AddItem(chest);

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetInt(266, 305);

			SetHits(60000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 30);

			SetDamageType(ResistanceType.Energy, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 65, 75);
			SetResistance(ResistanceType.Fire, 65, 75);
			SetResistance(ResistanceType.Cold, 65, 75);
			SetResistance(ResistanceType.Poison, 65, 75);
			SetResistance(ResistanceType.Energy, 65, 75);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Chivalry, 120.6, 130.5);
			SetSkill(SkillName.Archery, 130.1, 150.5);
			SetSkill(SkillName.Magery, 90.1, 120.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 120.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			PackItem(new Arrow(40));

			PackItem(Loot.RandomGrimmochJournal());

			if(0.05 > Utility.RandomDouble())
				PackItem((Item)Activator.CreateInstance(KhalAnkur.ExtraLoot[Utility.Random(KhalAnkur.ExtraLoot.Length)]));
		}

		public override int GetIdleSound()
		{
			return 0x178;
		}

		public override int GetAngerSound()
		{
			return 0x1AC;
		}

		public override int GetDeathSound()
		{
			return 0x27E;
		}

		public override int GetHurtSound()
		{
			return 0x177;
		}

		public override bool OnBeforeDeath()
		{
			if (!base.OnBeforeDeath())
				return false;

			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			Container pack = this.Backpack;
			if (pack != null)
			{
				pack.Movable = true;
				pack.MoveToWorld(Location, Map);
			}

			Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);
			return true;
		}

		public override void OnKilledBy(Mobile mob)
		{
			base.OnKilledBy(mob);

			if (mob.Talisman is KhalAnkurAmulet)
			{
				((KhalAnkurAmulet) mob.Talisman).SpendingPoints += 2;
			}

			if (Teragon.CheckArtifactChance(mob, this))
				Teragon.GiveArtifactTo(mob, this);
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (!InRange(from, 2) && Utility.RandomDouble() < 0.2)
				Summon(from);

			if (!m_FinalConfrontation && this.Hits < (this.HitsMax * 15) / 100/* && KhaldunRevenant.IsInsideKhaldun( this )*/)
			{
				m_FinalConfrontation = true;
				FinalConfrontation(this);
			}

			if (m_FinalConfrontation && this.Hits > (this.HitsMax * 75) / 100/* && KhaldunRevenant.IsInsideKhaldun( this )*/)
				m_FinalConfrontation = false;
		}

		private class ExpireTimer : Timer
		{
			private Mobile m_From;
			private int m_Count;

			public ExpireTimer(Mobile from) : base(TimeSpan.FromSeconds(0.5), TimeSpan.FromSeconds(0.5))
			{
				m_From = from;
				Priority = TimerPriority.TwentyFiveMS;
			}

			public void DoExpire()
			{
				Stop();

				foreach (Mobile m in m_From.GetMobilesInRange(12))
				{
					if (m != m_From && m.Player && m_From.CanBeHarmful(m) && m.AccessLevel == AccessLevel.Player && m_From.InLOS(m))
					{
						m.RevealingAction();
						m.FixedParticles(0x373A, 1, 17, 0x7E2, EffectLayer.Waist);
						m.Kill();
					}
				}

				m_From.FixedParticles(0x3709, 1, 30, 9965, 5, 7, EffectLayer.Waist);
				m_From.FixedParticles(0x376A, 1, 30, 9502, 5, 3, EffectLayer.Waist);
				m_From.PlaySound(226);
				m_From.CantWalk = false;
				m_From.Hits = m_From.HitsMax;
			}

			protected override void OnTick()
			{
				if (m_From == null || m_From.Deleted)
				{
					Stop();
					return;
				}

				if (m_From.Frozen || m_From.Paralyzed)
				{
					m_From.FixedParticles(0x373A, 10, 15, 5012, EffectLayer.Waist);
					m_From.PlaySound(765);
					m_From.PublicOverheadMessage(MessageType.Regular, 193, false, "Interrupted!");
					m_From.CantWalk = false;
					Stop();
					return;
				}

				m_From.Hits += 1000;

				if ((m_Count % 6) == 0)
				{
					m_From.FixedParticles(0x376A, 9, 32, 5007, EffectLayer.Waist);
					m_From.PlaySound(0x1E3);
				}

				if(++m_Count >= 30)
				{
					DoExpire();
				}
			}
		}

		public static void FinalConfrontation(Mobile from)
		{
			if (from != null && !from.Deleted)
			{
				from.FixedParticles(0x375A, 1, 17, 0x7DA, 0x960, 0x3, EffectLayer.Waist);
				from.PlaySound(1088);
				from.PublicOverheadMessage(MessageType.Regular, 193, false, String.Format("{0} channeling Final confrontation.", from.Name));
				from.PublicOverheadMessage(MessageType.Regular, 193, false, "Interrupt Him!");
				from.CantWalk = true;
				from.FixedEffect(0x376A, 6, 1);

				new ExpireTimer(from).Start();
			}
		}

		public void Summon(Mobile from)
		{
			Map map = this.Map;

			if (map == null || from == null)
				return;

			Mobile targ = null;

			if (from is PlayerMobile && from.Map == map)
				targ = from;

			MadSquirrel summon = new MadSquirrel(targ, 1.0);

			if (summon == null)
				return;

			bool validLocation = false;
			Point3D loc = this.Location;

			for (int j = 0; !validLocation && j < 10; ++j)
			{
				int x = X + Utility.Random(3) - 1;
				int y = Y + Utility.Random(3) - 1;
				int z = map.GetAverageZ(x, y);

				if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
					loc = new Point3D(x, y, Z);
				else if (validLocation = map.CanFit(x, y, z, 16, false, false))
					loc = new Point3D(x, y, z);
			}

			summon.Name = "a rat";
			summon.Body = 238;
			summon.BaseSoundID = 0xCC;
			summon.Hue = Utility.RandomHairHue();
			summon.MoveToWorld(loc, map);
		}

		public override bool AlwaysMurderer { get { return true; } }

		public GrimmochDrummel(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
			Blessed = false;
		}
	}
}