using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class LysanderGathenwale : BaseChampion
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool DeleteCorpseOnDeath { get { return true; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		private DateTime m_Delay = DateTime.Now;

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public LysanderGathenwale() : this (false, 3)
		{
		}

		[Constructable]
		public LysanderGathenwale(int range) : this (false, range)
		{
		}

		[Constructable]
		public LysanderGathenwale(bool ischampion, int range) : base(AIType.AI_Mage, FightMode.Closest, ischampion, range)
		{
			Title = "the Cursed";

			Hue = 0x8838;
			Body = 0x190;
			Name = "Lysander Gathenwale";

			HairItemID = 0x2048;	//Buns or Receeding Hair
			HairHue = 0x482;

			FacialHairItemID = 0x204B; // Medium short
			FacialHairHue = 0x482;

			DropMin = 50;
			DropMax = 100;
			BonusLoot = "tokens";
			BonusLootAmount = Utility.RandomMinMax(15, 30);

			AddItem(new Boots(0x599));
			AddItem(new Cloak(0x96F));

			Spellbook spellbook = new Spellbook();
			RingmailGloves gloves = new RingmailGloves();
			StuddedChest chest = new StuddedChest();
			PlateArms arms = new PlateArms();

			spellbook.Hue = 0x599;
			gloves.Hue = 0x599;
			chest.Hue = 0x96F;
			arms.Hue = 0x599;

			AddItem(spellbook);
			AddItem(gloves);
			AddItem(chest);
			AddItem(arms);

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetInt(1000, 1200);

			SetHits(60000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 30);

			SetDamageType(ResistanceType.Fire, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 65, 75);
			SetResistance(ResistanceType.Fire, 65, 75);
			SetResistance(ResistanceType.Cold, 65, 75);
			SetResistance(ResistanceType.Poison, 65, 75);
			SetResistance(ResistanceType.Energy, 65, 75);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Chivalry, 120.6, 130.5);
			SetSkill(SkillName.Archery, 130.1, 150.5);
			SetSkill(SkillName.Magery, 150.1, 160.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 120.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			Item reags = Loot.RandomReagent();
			reags.Amount = 30;
			PackItem(reags);

			if(0.05 > Utility.RandomDouble())
				PackItem((Item)Activator.CreateInstance(KhalAnkur.ExtraLoot[Utility.Random(KhalAnkur.ExtraLoot.Length)]));
		}

		public override int GetIdleSound()
		{
			return 0x1CE;
		}

		public override int GetAngerSound()
		{
			return 0x1AC;
		}

		public override int GetDeathSound()
		{
			return 0x182;
		}

		public override int GetHurtSound()
		{
			return 0x28D;
		}

		public override bool OnBeforeDeath()
		{
			if (!base.OnBeforeDeath())
				return false;

			Container pack = this.Backpack;
			if (pack != null)
			{
				pack.Movable = true;
				pack.MoveToWorld(Location, Map);
			}

			BaseBook notebook = Loot.RandomLysanderNotebook();
			notebook.MoveToWorld(Location, Map);

			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);
			return true;
		}

		public override void OnKilledBy(Mobile mob)
		{
			base.OnKilledBy(mob);

			if (mob.Talisman is KhalAnkurAmulet)
			{
				((KhalAnkurAmulet) mob.Talisman).SpendingPoints += 3;
			}

			if (Teragon.CheckArtifactChance(mob, this))
				Teragon.GiveArtifactTo(mob, this);
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (DateTime.Now > m_Delay && this.Hits < (this.HitsMax * 80) / 100)
			{
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(90, 120));
				// Effects
				Effects.PlaySound(this.Location, this.Map, this.GetAngerSound());
				// 				EffectCircle( this.Location, this.Map, 6, typeof( Skeleton ), this );
				SummoningRing(this, typeof(ShadowFiend));

				ArrayList targets = Utilitky.GetTargets(this, 8, true);

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.RevealingAction();
					m.PlaySound(0x50D);
					m.FixedParticles(0x37B9, 1, 5, 0x251D, 0x651, 0, EffectLayer.Waist);

					int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(15, 30), m);

					if (m is Xanthos.Interfaces.IEvoCreature)
						auradamage *= 2;

					m.Hits -= auradamage;
					m.Mana /= 2;
					ISTile5.SendDmgPacket(m, auradamage);

					if (m.Hits < 2)
						m.Kill();
				}
			}
		}

		public override void AlterMeleeDamageFrom(Mobile from, ref int damage)
		{
			if (from != null)
			{
				AOS.Damage(from, this, (damage / 2), 30, 70, 0, 0, 0);
				damage /= 10;
			}
		}

		#region Effects
		private static readonly double[] m_Offsets = new double[]
		{
			Math.Cos(000.0 / 180.0 * Math.PI), Math.Sin(000.0 / 180.0 * Math.PI),
			Math.Cos(040.0 / 180.0 * Math.PI), Math.Sin(040.0 / 180.0 * Math.PI),
			Math.Cos(080.0 / 180.0 * Math.PI), Math.Sin(080.0 / 180.0 * Math.PI),
			Math.Cos(120.0 / 180.0 * Math.PI), Math.Sin(120.0 / 180.0 * Math.PI),
			Math.Cos(160.0 / 180.0 * Math.PI), Math.Sin(160.0 / 180.0 * Math.PI),
			Math.Cos(200.0 / 180.0 * Math.PI), Math.Sin(200.0 / 180.0 * Math.PI),
			Math.Cos(240.0 / 180.0 * Math.PI), Math.Sin(240.0 / 180.0 * Math.PI),
			Math.Cos(280.0 / 180.0 * Math.PI), Math.Sin(280.0 / 180.0 * Math.PI),
			Math.Cos(320.0 / 180.0 * Math.PI), Math.Sin(320.0 / 180.0 * Math.PI),
		};

		public static void SummoningRing(Mobile summoner, Type mob)
		{
			Map map = summoner.Map;
			if (map != null)
			{
				for (int i = 0; i < m_Offsets.Length; i += 2)
				{
					double rx = m_Offsets[i];
					double ry = m_Offsets[i + 1];

					int dist = 0;
					bool ok = false;
					int x = 0, y = 0, z = 0;

					while (!ok && dist < 10)
					{
						int rdist = 10 + dist;

						x = summoner.X + (int)(rx * rdist);
						y = summoner.Y + (int)(ry * rdist);
						z = map.GetAverageZ(x, y);

						if (!(ok = map.CanFit(x, y, summoner.Z, 16, false, false)))
							ok = map.CanFit(x, y, z, 16, false, false);

						if (dist >= 0)
							dist = -(dist + 1);
						else
							dist = -(dist - 1);
					}

					if (!ok)
						continue;

					SummonMob(new Point3D(x, y, z), mob, summoner);
				}
			}
		}

		private static void SummonMob(Point3D p, Type mob, Mobile summoner)
		{
			if (summoner != null && summoner.Map.CanSpawnMobile(p) && summoner.InLOS(p))
			{
				BaseCreature spawned = Activator.CreateInstance(mob) as BaseCreature;

				if (spawned != null)
				{
					TimeSpan duration = TimeSpan.FromSeconds(40.0);

					new Server.Spells.UnsummonTimer(summoner, spawned, duration).Start();
					spawned.SummonEnd = DateTime.Now + duration;

					if (Paragon.CheckConvert(spawned, p, summoner.Map))
						spawned.IsParagon = true;

					if (Teragon.CheckConvert(spawned, p, summoner.Map))
						spawned.IsTeragon = true;

					spawned.SetHits(500);
					spawned.MoveToWorld(p, summoner.Map);
					Effects.PlaySound(p, summoner.Map, spawned.GetAngerSound());
				}
			}
		}

		#endregion

		public override bool AlwaysMurderer { get { return true; } }

		public LysanderGathenwale(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}