using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Network;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class MorgBergen : BaseChampion
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool DeleteCorpseOnDeath { get { return true; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ArmorIgnore : WeaponAbility.CrushingBlow;
		}

		[Constructable]
		public MorgBergen() : this (false, 3)
		{
		}

		[Constructable]
		public MorgBergen(int range) : this (false, range)
		{
		}

		[Constructable]
		public MorgBergen(bool ischampion, int range) : base(AIType.AI_Paladin, FightMode.Closest, ischampion, range)
		{
			Title = "the Cursed";

			Hue = 0x8596;
			Body = 0x190;
			Name = "Morg Bergen";

			HairItemID = 0x203B; // Short
			HairHue = 0x460;

			FacialHairItemID = 0x2041; // Mustache
			FacialHairHue = 0x460;

			DropMin = 50;
			DropMax = 100;
			BonusLoot = "tokens";
			BonusLootAmount = Utility.RandomMinMax(15, 30);

			AddItem(new ShortPants(0x59C));

			Bardiche bardiche = new Bardiche();
			LeatherGloves gloves = new LeatherGloves();
			LeatherArms arms = new LeatherArms();

			bardiche.Hue = 0x96F;
			bardiche.Movable = false;
			bardiche.WeaponAttributes.HitLightning = 30;
			bardiche.WeaponAttributes.HitLeechHits = 40;
			bardiche.WeaponAttributes.HitLeechStam = 40;
			bardiche.WeaponAttributes.HitPhysicalArea = 40;
			// 			bardiche.WeaponAttributes.HitLowerDefend = 100;
			gloves.Hue = 0x96F;
			arms.Hue = 0x96F;

			AddItem(bardiche);
			AddItem(gloves);
			AddItem(arms);

			SetStr(700, 720);
			SetDex(280, 300);
			SetInt(266, 305);

			SetHits(60000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 30);

			SetDamageType(ResistanceType.Energy, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 65, 75);
			SetResistance(ResistanceType.Fire, 65, 90);
			SetResistance(ResistanceType.Cold, 65, 75);
			SetResistance(ResistanceType.Poison, 65, 75);
			SetResistance(ResistanceType.Energy, 65, 75);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Chivalry, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 90.1, 120.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 120.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			if(0.3 > Utility.RandomDouble())
				PackItem(new GlassSword());

			if(0.05 > Utility.RandomDouble())
				PackItem((Item)Activator.CreateInstance(KhalAnkur.ExtraLoot[Utility.Random(KhalAnkur.ExtraLoot.Length)]));
		}

		public override int GetIdleSound()
		{
			return 0x1CE;
		}

		public override int GetAngerSound()
		{
			return 0x263;
		}

		public override int GetDeathSound()
		{
			return 0x1D1;
		}

		public override int GetHurtSound()
		{
			return 0x25E;
		}

		public override bool OnBeforeDeath()
		{
			if (!base.OnBeforeDeath())
				return false;

			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			Container pack = this.Backpack;
			if (pack != null)
			{
				pack.Movable = true;
				pack.MoveToWorld(Location, Map);
			}

			Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);
			return true;
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if(from is BaseCreature && this.Hits < (this.HitsMax / 2) && Utility.RandomDouble() < 0.2)
			{
				BaseCreature creature = (BaseCreature) from;

				if (creature == null) return;

				if (creature.Controlled || creature.Summoned)
				{
					Heal(creature.Hits);
					creature.Kill();

					Effects.PlaySound(Location, Map, 0x574);
				}
			}

			if (0.02 >= Utility.RandomDouble())
			{
				Ability.DamageArmor(from, 2, 5);
				Ability.CriticalHit(from);
			}

			if(Alive && !Deleted && Utility.RandomDouble() < 0.075)
			{
				if (!Summoned && !Blessed)
				{
					ArrayList targets = Utilitky.GetTargets(this, 10, true);

					for (int i = 0; i < targets.Count; ++i)
					{
						Mobile m = (Mobile)targets[i];

						if (m == null || m.Deleted)
							continue;

						m.RevealingAction();

						if (BleedAttack.IsBleeding(m))
							continue;

						this.MovingParticles(m, 10231, 5, 3, false, false, 3006, 4006, 0);

						int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(10, 20), m);

						if (m is Xanthos.Interfaces.IEvoCreature)
							auradamage *= 2;

						m.Hits -= auradamage;
						ISTile5.SendDmgPacket(m, auradamage);

						if (m.Hits < 2)
							m.Kill();

						if (m.Alive && !(DaemonHelm.FullDeamonSetPresent(m) || (m is BaseCreature && ((BaseCreature)m).BleedImmune)))
						{
							BleedAttack.BeginBleed(m, this);

							if (m is PlayerMobile)
							{
								m.LocalOverheadMessage(MessageType.Regular, 0x21, 1060757); // You are bleeding profusely
							}

							m.PlaySound(0x133);
							m.FixedParticles(0x377A, 244, 25, 9950, 31, 0, EffectLayer.Waist);
						}
					}

					if (targets.Count > 0)
					{
						this.PlaySound(0x20C);
						this.PlaySound(0x232);
						this.FixedParticles(0x3779, 1, 30, 9964, 3, 3, EffectLayer.Waist);
					}
				}
			}
		}

		public override void OnKilledBy(Mobile mob)
		{
			base.OnKilledBy(mob);

			if (mob.Talisman is KhalAnkurAmulet)
			{
				((KhalAnkurAmulet) mob.Talisman).SpendingPoints += 1;
			}

			if (Teragon.CheckArtifactChance(mob, this))
				Teragon.GiveArtifactTo(mob, this);
		}

		public override bool AlwaysMurderer { get { return true; } }

		public MorgBergen(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}