using System;
using Server.Items;
using Server.Engines.XmlSpawner2;
using Server.Network;

namespace Server.Mobiles
{
    //[CorpseName("Corpse Of KhaldunEnchanter")]
    public class KhaldunEnchanter : BaseCreature
    {
        private int Price { get { return KhaldunRevenant.IsInsideKhaldun(this) ? 3 : 10; } }
        public override bool DisallowAllMoves { get { return true; } }

        [Constructable]
        public KhaldunEnchanter()
            : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            Name = "Zeddicus";
            Title = "the Enchanter";
            Body = 400;
            CantWalk = true;
            Hue = 33770;
            Blessed = true;
            Female = false;

            InitStats(100, 100, 25);

            HairItemID = 0x203C;
            HairHue = 0x455;
            FacialHairItemID = 8268;
            FacialHairHue = 0x455;

            AddItem(new Robe(2540));
            AddItem(new Sandals(962));

            Spellbook book = new Spellbook();
            book.Movable = false;
            book.Hue = 962;
            AddItem(book);
        }

        public KhaldunEnchanter(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }

        public override bool HandlesOnSpeech(Mobile from)
        {
            base.HandlesOnSpeech(from);
            return true;
        }

        public override void OnSpeech(SpeechEventArgs e)
        {
            Mobile from = e.Mobile;

            string keyword = "hi";
            string keyword2 = "ahoj";

            if ((e.Speech.ToLower().IndexOf(keyword.ToLower()) >= 0) || (e.Speech.ToLower().IndexOf(keyword2.ToLower()) >= 0))
            {
                SayTo(from, "Zdravim te!");
                SayTo(from, "Pokud mi das {0} fragmentu artefaktu, mohu ocarovat tvoji zbran nebo magickou knihu na {1} hodin.", Price, KhaldunRevenant.IsInsideKhaldun(this) ? 24 : 12);
                PlaySound(1049);
                e.Handled = true;
            }

            base.OnSpeech(e);
        }

        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            if (from == null) return false;

            if (dropped is ArtifactFragment && dropped.Amount == Price)
            {
                double duration = KhaldunRevenant.IsInsideKhaldun(this) ? 1440.0 : 720.0;

                if (from.Weapon is BaseWeapon && !(from.Weapon is Fists))
                {
                    XmlAttach.AttachTo((BaseWeapon)from.Weapon, new XmlEnchantWeaponDamage(5, duration));

                    SayTo(from, "S touto zbrani nyni zpusobis nepratelum vetsi skodu.");
                    PlaySound(1051);
                    dropped.Delete();
                    FixedParticles(0x373A, 10, 15, 5018, EffectLayer.Waist);
                    PlaySound(0x1EA);
                    return true;
                }
                else if (Spellbook.FindEquippedSpellbook(from) != null)
                {
                    XmlAttach.AttachTo(Spellbook.FindEquippedSpellbook(from), new XmlEnchantConsecrateSpell(duration));

                    SayTo(from, "Kazde tve kouzlo nyni zasahne nepritele na nejcitlivejsim miste.");
                    dropped.Delete();
                    PlaySound(1051);
                    PlaySound(0x1E9);
                    FixedParticles(0x375A, 10, 15, 5037, EffectLayer.Waist);
                    return true;
                }
                else
                    SayTo(from, "Nemas v ruce zbran ani magickou knihu, nevim co chces ocarovat.");
            }
            else
                SayTo(from, "Rikal jsem at mi das {0} fragmentu artefaktu!", Price);

            PlaySound(1071);

            return false;
        }
    }
}



