using System;
using Server;
using Server.Items;
using Server.Spells;
using Server.Network;
using System.Collections;

namespace Server.Mobiles
{
    public class KhaldunLich : BaseCreature
    {
        [Constructable]
        public KhaldunLich() : base(AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            SpeechHue = Utility.RandomDyedHue();
            Hue = Utility.RandomNeutralHue();
            Female = false;
            BodyValue = 24;
            BaseSoundID = 1001;
            Name = NameList.RandomName("ancient lich");
            Title = "the Ancient lich";

            SetStr(516, 605);
            SetDex(106, 115);
            SetInt(296, 305);

            SetHits(2600, 3000);
            SetMana(2500);

            SetDamage(10, 25);

            SetDamageType(ResistanceType.Fire, 70);
            SetDamageType(ResistanceType.Physical, 15);
            SetDamageType(ResistanceType.Energy, 15);

            SetResistance(ResistanceType.Physical, 50, 70);
            SetResistance(ResistanceType.Fire, 100);
            SetResistance(ResistanceType.Cold, 20, 50);
            SetResistance(ResistanceType.Poison, 50, 60);
            SetResistance(ResistanceType.Energy, 40, 70);

            SetSkill(SkillName.EvalInt, 100.6, 110.5);
            SetSkill(SkillName.Necromancy, 120.6, 130.5);
            SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
            SetSkill(SkillName.Magery, 90.1, 120.1);
            SetSkill(SkillName.Poisoning, 80.5);
            SetSkill(SkillName.Meditation, 110.0);
            SetSkill(SkillName.MagicResist, 80.1, 85.0);
            SetSkill(SkillName.Parry, 90.1, 95.1);
            SetSkill(SkillName.Tactics, 100.0);
            SetSkill(SkillName.Anatomy, 100.0);
            SetSkill(SkillName.Wrestling, 90.1, 120.0);

            Fame = 10000;
            Karma = -15000;

            VirtualArmor = 65;

            PackNecroReg(50, 70);

            if (Utility.RandomDouble() < 0.2)
                PackItem(new RandomTalisman());
        }

        public override void GenerateLoot()
        {
            AddLoot(LootPack.UltraRich, 2);
        }

        public override void OnKilledBy(Mobile mob)
        {
            base.OnKilledBy(mob);

            if (Paragon.CheckArtifactChance(mob, this) && mob.Talisman is KhalAnkurAmulet)
            {
                ((KhalAnkurAmulet)mob.Talisman).SpendingPoints++;
            }
        }

        public override bool CanRummageCorpses { get { return true; } }
        public override bool AlwaysMurderer { get { return true; } }
        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }
        public override Poison PoisonImmune { get { return Poison.Deadly; } }
        public override int TreasureMapLevel { get { return 5; } }
        public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

        public void SpawnWraiths(Mobile target)
        {
            Map map = this.Map;

            if (map == null)
                return;

            int newWraiths = Utility.RandomMinMax(3, 6);

            for (int i = 0; i < newWraiths; ++i)
            {
                BlackLichWraith wraith = new BlackLichWraith();

                wraith.Team = this.Team;
                wraith.FightMode = FightMode.Closest;
                wraith.Hue = 0x4001;
                wraith.Name = "a shadow wraith";
                wraith.SetResistance(ResistanceType.Fire, 100);
                wraith.SetResistance(ResistanceType.Energy, 100);
                // 				wraith.Summoned = true;
                // 			   wraith.SummonMaster = this;

                bool validLocation = false;
                Point3D loc = this.Location;

                for (int j = 0; !validLocation && j < 10; ++j)
                {
                    int x = X + Utility.Random(3) - 1;
                    int y = Y + Utility.Random(3) - 1;
                    int z = map.GetAverageZ(x, y);

                    if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
                        loc = new Point3D(x, y, Z);
                    else if (validLocation = map.CanFit(x, y, z, 16, false, false))
                        loc = new Point3D(x, y, z);
                }

                if (Teragon.CheckConvert(wraith, loc, map))
                    wraith.IsTeragon = true;

                wraith.SetHits(300, 500);
                wraith.MoveToWorld(loc, map);
                wraith.Combatant = null;
            }
        }

        public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
        {
            base.OnDamage(amount, from, willKill, typ);

            if (from == null)
                return;

            if (0.003 > Utility.RandomDouble())
            {
                ExpireTimer timer = (ExpireTimer)m_Table[from];

                if (timer == null)
                {
                    this.PublicOverheadMessage(MessageType.Regular, 193, true, String.Format("Corrupt body on {0}!", from.RawName));
                    this.PlaySound(1002);
                    from.SolidHueOverride = 0x4001;
                    timer = new ExpireTimer(from, this);
                    timer.Start();
                    m_Table[from] = timer;
                }
            }

            if (0.01 > Utility.RandomDouble())
                SpawnWraiths(from);
        }

        public override void OnGaveMeleeAttack(Mobile defender)
        {
            base.OnGaveMeleeAttack(defender);

            // 			defender.Damage( Utility.Random( 20, 10 ), this );
            defender.Stam -= Utility.Random(5, 15);
            defender.Mana -= Utility.Random(5, 20);
        }

        private static Hashtable m_Table = new Hashtable();

        private class ExpireTimer : Timer
        {
            private Mobile m_Mobile;
            private Mobile m_From;
            private int m_Count;

            public ExpireTimer(Mobile m, Mobile from)
            : base(TimeSpan.FromSeconds(5.0), TimeSpan.FromSeconds(5.0))
            {
                m_Mobile = m;
                m_From = from;
                Priority = TimerPriority.OneSecond;
            }

            public void DoExpire()
            {
                Stop();
                m_Table.Remove(m_Mobile);
                m_Mobile.SendMessage("Corrupt body faded");
                m_Mobile.SolidHueOverride = -1;
            }

            public void DrainLife()
            {
                if (m_Mobile.Alive && !m_Mobile.Blessed && !m_Mobile.Deleted)
                {
                    m_Mobile.PlaySound(1001);
                    m_Mobile.FixedParticles(0x36CB, 1, 9, 9911, 67, 5, EffectLayer.Head);
                    m_Mobile.FixedParticles(0x374A, 1, 17, 9502, 1108, 4, (EffectLayer)255);

                    int damage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(25, 40), m_Mobile);

                    if (m_Mobile.Talisman is KhalAnkurAmulet)
                        damage /= 2;

                    m_Mobile.Hits -= damage;
                    ISTile5.SendDmgPacket(m_Mobile, damage);

                    if (m_Mobile.Hits < 2)
                        m_Mobile.Kill();
                }
                else
                    DoExpire();
            }

            protected override void OnTick()
            {
                DrainLife();

                if (Utility.RandomBool())
                    m_Mobile.Paralyze(TimeSpan.FromSeconds(1.5));

                if (++m_Count >= 3)
                {
                    DoExpire();
                }
            }
        }

        public KhaldunLich(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}