using System;
using Server.Misc;
using Server.Network;
using System.Collections;
using System.Collections.Generic;
using Server.Items;

namespace Server.Mobiles
{
	public class KhaldunZealot : BaseCreature
	{
		public override bool ClickTitle{ get{ return false; } }
		public override bool ShowFameTitle{ get{ return false; } }
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.BleedAttack;
					case 2: return WeaponAbility.CrushingBlow;
			}
		}

		[Constructable]
		public KhaldunZealot(): base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Body = 0x190;
			Name = "Zealot of Khaldun";
			Title = "the Knight";
			Hue = 0;

			SetStr( 516, 605 );
			SetDex( 200, 250 );
			SetInt( 266, 305 );

			SetHits( 1700, 2200 );
			SetMana( 2500 );
			SetStam( 1000 );

			SetDamage( 19, 25 );

			SetDamageType( ResistanceType.Cold, 70 );
			SetDamageType( ResistanceType.Physical, 30 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Fire, 50, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 50, 70 );

			SetSkill( SkillName.EvalInt, 77.6, 110.5 );
			SetSkill( SkillName.Necromancy, 120.6, 130.5 );
			SetSkill( SkillName.SpiritSpeak, 120.1, 150.5 );
			SetSkill( SkillName.Magery, 90.1, 120.1);
			SetSkill( SkillName.Poisoning, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.MagicResist, 80.1, 85.0 );
			SetSkill( SkillName.Parry, 90.1, 95.1 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 70.1, 150.0 );
			SetSkill( SkillName.Swords, 120.1, 130.0 );
			SetSkill( SkillName.Anatomy, 100.0 );

			Fame = 10000;
			Karma = -10000;
			VirtualArmor = 40;

			VikingSword weapon = new VikingSword();
			weapon.Hue = 0x835;
			weapon.WeaponAttributes.HitHarm = 40;
			weapon.WeaponAttributes.HitLeechHits = 40;
			weapon.Movable = false;
			AddItem( weapon );

			MetalShield shield = new MetalShield();
			shield.Hue = 0x835;
			shield.Movable = false;
			AddItem( shield );

			BoneHelm helm = new BoneHelm();
			helm.Hue = 0x835;
			AddItem( helm );

			BoneArms arms = new BoneArms();
			arms.Hue = 0x835;
			AddItem( arms );

			BoneGloves gloves = new BoneGloves();
			gloves.Hue = 0x835;
			AddItem( gloves );

			BoneChest tunic = new BoneChest();
			tunic.Hue = 0x835;
			AddItem( tunic );

			BoneLegs legs = new BoneLegs();
			legs.Hue = 0x835;
			AddItem( legs );

			AddItem( new Boots() );
		}

		public override int GetIdleSound()
		{
			return 0x184;
		}

		public override int GetAngerSound()
		{
			return 0x286;
		}

		public override int GetDeathSound()
		{
			return 0x288;
		}

		public override int GetHurtSound()
		{
			return 0x19F;
		}

		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public KhaldunZealot( Serial serial ) : base( serial )
		{
		}

		public override bool OnBeforeDeath()
		{
			BoneWarrior rm = new BoneWarrior();
			rm.Team = this.Team;
			rm.Combatant = this.Combatant;
			rm.NoKillAwards = true;

			if ( rm.Backpack == null )
			{
				Backpack pack = new Backpack();
				pack.Movable = false;
				rm.AddItem( pack );
			}

			for ( int i = 0; i < 2; i++ )
			{
				LootPack.FilthyRich.Generate( this, rm.Backpack, true, LootPack.GetLuckChanceForKiller( this ) );
				LootPack.FilthyRich.Generate( this, rm.Backpack, false, LootPack.GetLuckChanceForKiller( this ) );
			}

			Effects.PlaySound(this, Map, GetDeathSound());
			Effects.SendLocationEffect( Location, Map, 0x3709, 30, 10, 0x835, 0 );
			rm.MoveToWorld( Location, Map );
			Server.Regions.KhaldunRegion.DropHealthOrb( this );
			
			Delete();
			return false;
		}
		
		public override void OnDamagedBySpell( Mobile attacker )
		{
			if ( 0.6 > Utility.RandomDouble() && !attacker.InRange( this, 1 ) )
			{
				int effId = 0x2D22;
				
				if ( this.Weapon is BaseWeapon && !( this.Weapon is Fists ) )
					effId = ((Item)this.Weapon).ItemID;
				
				Effects.SendPacket( attacker, attacker.Map, new HuedEffect( EffectType.Moving, Serial.Zero, Serial.Zero, effId, this.Location, attacker.Location, 10, 0, false, false, 0, 0 ) );
				AOS.Damage( attacker, this, Utility.RandomMinMax( 80, 110 ), 50, 0, 0, 0, 50 );
			}
			else
				base.OnDamagedBySpell( attacker );
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );
			
			if ( Paragon.CheckArtifactChance( mob, this ) && mob.Talisman is KhalAnkurAmulet )
			{
				((KhalAnkurAmulet) mob.Talisman).SpendingPoints++;
			}
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			if ( 0.075 > Utility.RandomDouble() )
			{
				/* Rune Corruption
				 * Start cliloc: 1070846 "The creature magically corrupts your armor!"
				 * Effect: All resistances -70 (lowest 0) for 5 seconds
				 * End ASCII: "The corruption of your armor has worn off"
				 */

				ExpireTimer timer = (ExpireTimer)m_Table[defender];

				if ( timer != null )
				{
					timer.DoExpire();
					defender.SendLocalizedMessage( 1070845 ); // The creature continues to corrupt your armor!
				}
				else
					defender.SendLocalizedMessage( 1070846 ); // The creature magically corrupts your armor!

				List<ResistanceMod> mods = new List<ResistanceMod>();

				if ( defender.PhysicalResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Physical, (defender.PhysicalResistance > 70) ? -70 : -defender.PhysicalResistance ) );

				if ( defender.FireResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Fire, (defender.FireResistance > 70) ? -70 : -defender.FireResistance ) );

				if ( defender.ColdResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Cold, (defender.ColdResistance > 70) ? -70 : -defender.ColdResistance ) );

				if ( defender.PoisonResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Poison, (defender.PoisonResistance > 70) ? -70 : -defender.PoisonResistance ) );

				if ( defender.EnergyResistance > 0 )
					mods.Add( new ResistanceMod( ResistanceType.Energy, (defender.EnergyResistance > 70) ? -70 : -defender.EnergyResistance ) );

				for ( int i = 0; i < mods.Count; ++i )
					defender.AddResistanceMod( mods[i] );

				defender.FixedEffect( 0x37B9, 10, 5 );

				timer = new ExpireTimer( defender, mods, TimeSpan.FromSeconds( 3.0 ) );
				timer.Start();
				m_Table[defender] = timer;
			}
			
			if ( Utility.RandomDouble() < 0.025 )
			{
				ArrayList targets = new ArrayList();
				
				foreach ( Mobile m in this.GetMobilesInRange( 10 ) )
				{
					if ( m == null || m.Deleted )
						continue;
					
					if ( m == this || !CanBeHarmful( m ) )
						continue;

					if ( m is BaseCreature && ((BaseCreature)m).Summoned )
						targets.Add(m);
				}
				
				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];
					
					if ( m == null || m.Deleted )
						continue;

					m.Kill();
				}
				
				this.PlaySound( 654 );
			}
			
			if ( Utility.RandomDouble() < 0.035 && defender.Player )
				KhalAnkur.Waller( 3, 6, defender );
			
			base.OnGaveMeleeAttack( defender );
		}

		private static Hashtable m_Table = new Hashtable();

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;
			private List<ResistanceMod> m_Mods;

			public ExpireTimer( Mobile m, List<ResistanceMod> mods, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
				m_Mods = mods;
				Priority = TimerPriority.TwoFiftyMS;
			}

			public void DoExpire()
			{
				for ( int i = 0; i < m_Mods.Count; ++i )
					m_Mobile.RemoveResistanceMod( m_Mods[i] );

				Stop();
				m_Table.Remove( m_Mobile );
			}

			protected override void OnTick()
			{
				m_Mobile.SendMessage( "The corruption of your armor has worn off" );
				DoExpire();
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
