using System;
using System.Collections;
using System.Collections.Generic;
using Server.Items;
using Server.ContextMenus;

namespace Server.Mobiles
{
    //[CorpseName( "a ghostly corpse" )]
    public class RestlessGhost : BaseCreature
    {
        [Constructable]
        public RestlessGhost() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.4, 0.8)
        {
            Name = "a restless ghost";
            Body = 0x3CA;
            Hue = 0x453;

            SetStr(256, 300);
            SetDex(200, 255);
            SetInt(36, 60);

            SetHits(500, 600);
            SetStam(518, 550);

            SetDamage(19, 20);

            SetDamageType(ResistanceType.Physical, 40);
            SetDamageType(ResistanceType.Cold, 60);

            SetResistance(ResistanceType.Physical, 60, 65);
            SetResistance(ResistanceType.Fire, 50, 59);
            SetResistance(ResistanceType.Cold, 50, 60);
            SetResistance(ResistanceType.Poison, 50, 60);
            SetResistance(ResistanceType.Energy, 50, 70);

            SetSkill(SkillName.MagicResist, 85.1, 90.0);
            SetSkill(SkillName.Tactics, 110.1, 120.0);
            SetSkill(SkillName.Wrestling, 110.1, 120.0);
            SetSkill(SkillName.Anatomy, 80.1, 120.0);

            Fame = 14000;
            Karma = -6000;

            VirtualArmor = 40;

            // 			EnergyBow bow = new EnergyBow();
            // 			bow.WeaponAttributes.HitLightning = 30;
            // 			bow.Movable = false;
            // 			bow.MinDamage = 30;
            // 			bow.MaxDamage = 50;
            // 			bow.Hue = 0x4001;

            Backpack backpack = new Backpack();
            backpack.Movable = false;
            AddItem(backpack);

            // 			AddItem( bow );
        }

        public override bool AlwaysAttackable { get { return true; } }
        public override bool BleedImmune { get { return true; } }
        public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
        public override Poison PoisonImmune { get { return Poison.Lethal; } }
        public override Poison HitPoison { get { return Poison.Lesser; } }
        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }
        public override bool DeleteCorpseOnDeath { get { return true; } }

        public override bool OnBeforeDeath()
        {
            if (Backpack != null)
            {
                Backpack.DropItem(new Gold(Utility.RandomMinMax(190, 320)));
                Backpack.Destroy();
            }

            Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);

            Map map = this.Map;

            if (map == null)
                return true;

            for (int i = 0; i < 12; ++i)
            {
                MeerGiantSerpent worm = new MeerGiantSerpent();

                worm.Team = this.Team;
                worm.FightMode = FightMode.Closest;
                worm.Hue = 0x4001;
                worm.Name = "a shadow worm";
                worm.Body = 52;
                worm.BaseSoundID = 0xDB;
                worm.SetHits(200, 300);
                worm.SetDamage(15, 18);
                worm.SetResistance(ResistanceType.Fire, 100);
                worm.SetResistance(ResistanceType.Energy, 100);

                bool validLocation = false;
                Point3D loc = this.Location;

                for (int j = 0; !validLocation && j < 10; ++j)
                {
                    int x = X + Utility.Random(4) - 1;
                    int y = Y + Utility.Random(4) - 1;
                    int z = map.GetAverageZ(x, y);

                    if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
                        loc = new Point3D(x, y, Z);
                    else if (validLocation = map.CanFit(x, y, z, 16, false, false))
                        loc = new Point3D(x, y, z);
                }

                if (Teragon.CheckConvert(worm, loc, map))
                    worm.IsTeragon = true;


                worm.MoveToWorld(loc, map);
            }

            return true;
        }

        public override void AlterSpellDamageFrom(Mobile from, ref int damage)
        {
            damage = 0;

            if (!KhalAnkur.IsUnderInfluence(from))
            {
                KhalAnkur.Silence(from, this);
            }
        }

        public override void DisplayPaperdollTo(Mobile to)
        {
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            base.GetContextMenuEntries(from, list);

            for (int i = 0; i < list.Count; ++i)
            {
                if (list[i] is ContextMenus.PaperdollEntry)
                    list.RemoveAt(i--);
            }
        }

        public override void OnKilledBy(Mobile mob)
        {
            base.OnKilledBy(mob);

            if (Paragon.CheckArtifactChance(mob, this) && mob.Talisman is KhalAnkurAmulet)
            {
                ((KhalAnkurAmulet)mob.Talisman).SpendingPoints++;
            }
        }

        public override int GetIdleSound()
        {
            return 0x1BF;
        }

        public override int GetAngerSound()
        {
            return 0x107;
        }

        public override int GetDeathSound()
        {
            return 0xFD;
        }

        public override bool IsEnemy(Mobile m)
        {
            return base.IsEnemy(m);
        }

        public RestlessGhost(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}
