using System;
using Server;
using Server.Items;
using Server.Spells;
using System.Collections;
using Server.Network;

namespace Server.Mobiles
{
	public class Scavenger : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.ArmorIgnore;
					case 2: return WeaponAbility.ConcussionBlow;
			}
		}
		
		[Constructable]
		public Scavenger() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			SpeechHue = Utility.RandomHairHue();
			Hue = SpeechHue | 0x8000;
			Body = 302;
			BaseSoundID = 959;
			Name = "a scavenger";

			SetStr( 516, 605 );
			SetDex( 106, 115 );
			SetInt( 266, 305 );

			SetHits( 1000, 1300 );
			SetMana( 2500 );

			SetDamage( 19, 25 );

			SetDamageType( ResistanceType.Fire, 60 );
			SetDamageType( ResistanceType.Physical, 20 );
			SetDamageType( ResistanceType.Energy, 20 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Fire, 70 );
			SetResistance( ResistanceType.Cold, 30, 50 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 50, 75 );

			SetSkill( SkillName.EvalInt, 77.6, 120.5 );
			SetSkill( SkillName.Magery, 90.1, 150.1);
			SetSkill( SkillName.Anatomy, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.MagicResist, 80.1, 85.0 );
			SetSkill( SkillName.Parry, 90.1, 95.1 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 90.1, 120.0 );

			Fame = 19000;
			Karma = -15000;

			VirtualArmor = 65;
			
			if ( Utility.RandomDouble() < 0.5 )
				PackItem( new LesserHealPotion() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 1 );
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );
			
			if ( Paragon.CheckArtifactChance( mob, this ) && mob.Talisman is KhalAnkurAmulet )
			{
				((KhalAnkurAmulet) mob.Talisman).SpendingPoints++;
			}
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override int Meat{ get{ return 3; } }
		public override HideType HideType{ get{ return ( this.IsTeragon ) ? HideType.Daemon : HideType.Spined; } }
		public override int Hides{ get{ return 10; } }
		
		public override bool Rummage()
		{
			if ( this.Hits > ( this.HitsMax / 3 ) )
				return false;
			
			Corpse toRummage = null;

			foreach (Item item in this.GetItemsInRange(2))
			{
				if ( item is Corpse && !((Corpse)item).Carved )
				{
					toRummage = (Corpse)item;
					break;
				}
			}

			if (toRummage == null)
				return false;

			toRummage.Carved = true;
			this.Heal( Server.Engines.XmlSpawner2.XmlSpecial.PercentualDamage( 75, this) );
			this.PublicOverheadMessage( MessageType.Regular, SpeechHue, false, String.Format("*{0} feasts on corpse*", this.Name) );
			Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x374A, 9, 32, 5024 );
			Effects.PlaySound( Location, Map, 59 );
			Effects.PlaySound( Location, Map, 80 );

			return true;
		}

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			// 			if( 0.055 > Utility.RandomDouble() )
			// 				SpawnFury( from );

			// teleports to player
			if ( from is PlayerMobile && !InRange( from.Location, 4 ) && Utility.RandomDouble() < 0.03 )
			{
				Combatant = from;
				
				this.MoveToWorld( from.Location, from.Map );
				this.FixedParticles( 0x376A, 9, 32, 0x13AF, EffectLayer.Waist );
				this.PlaySound( 0x1FE );
			}

			// from.Stam -= Utility.Random( 1, 10 );
			// from.Mana -= Utility.Random( 1, 10 );
			
			base.OnDamage( amount, from, willKill, typ );
		}

		public Scavenger( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
