using Server.Items;
using System;
using System.Collections;

namespace Server.Mobiles
{
    public class SkullFury : BaseCreature
    {
        public override bool DeleteCorpseOnDeath { get { return Summoned; } }
        public override double DispelDifficulty { get { return 70.0; } }
        public override double DispelFocus { get { return 20.0; } }
        public override Poison PoisonImmune { get { return Poison.Lethal; } }
        public override Poison HitPoison { get { return Poison.Deadly; } }
        public override bool AlwaysMurderer { get { return true; } }
        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }
        public override bool BleedImmune { get { return true; } }

        [Constructable]
        public SkullFury() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            Name = "a skull fury";
            Body = 0x33;
            Hue = 0x4001;

            SetStr(500, 580);
            SetDex(150, 200);
            SetInt(100);

            SetHits(900, 1000);
            SetStam(250);
            SetMana(0);

            SetDamage(18, 20);

            SetDamageType(ResistanceType.Cold, 90);
            SetDamageType(ResistanceType.Physical, 10);

            SetResistance(ResistanceType.Physical, 100);
            SetResistance(ResistanceType.Fire, 100);
            SetResistance(ResistanceType.Cold, 70);
            SetResistance(ResistanceType.Poison, 100);
            SetResistance(ResistanceType.Energy, 70);

            SetSkill(SkillName.Wrestling, 130.0);
            SetSkill(SkillName.MagicResist, 70.0);
            SetSkill(SkillName.Tactics, 150.0);
            SetSkill(SkillName.Anatomy, 100.0);

            Fame = 6000;
            Karma = 580;

            ControlSlots = 1;
        }

        public override void GenerateLoot()
        {
            if (!Summoned)
            {
                AddLoot(LootPack.FilthyRich);
            }
        }

        public override void OnKilledBy(Mobile mob)
        {
            base.OnKilledBy(mob);

            if (Paragon.CheckArtifactChance(mob, this) && mob.Talisman is KhalAnkurAmulet)
            {
                ((KhalAnkurAmulet)mob.Talisman).SpendingPoints++;
            }
        }

        public override void MoveToWorld(Point3D loc, Map map)
        {
            base.MoveToWorld(loc, map);
            Timer.DelayCall(TimeSpan.FromSeconds(0.1), DoEffects);
        }

        public void DoEffects()
        {
            if (Alive && !Deleted)
            {
                FixedParticles(7967, 10, 180, 0x2543, 0, 0, EffectLayer.Waist);
                PlaySound(1154);
                PlaySound(1201);

                Timer.DelayCall(TimeSpan.FromSeconds(6.0), DoEffects);

                if (!Summoned && !Blessed)
                {
                    ArrayList targets = Utilitky.GetTargets(this, 12, true);

                    for (int i = 0; i < targets.Count; ++i)
                    {
                        Mobile m = (Mobile)targets[i];

                        if (m == null || m.Deleted)
                            continue;

                        m.RevealingAction();
                        DoHarmful(m);
                        m.PlaySound(1154);
                        this.MovingParticles(m, 7967, 5, 3, false, false, 3006, 4006, 0);

                        int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(15, 25), m);

                        if (m is Xanthos.Interfaces.IEvoCreature)
                            auradamage *= 2;

                        m.Hits -= auradamage;
                        ISTile5.SendDmgPacket(m, auradamage);

                        if (m.Hits < 2)
                            m.Kill();
                    }
                }
            }
        }

        public SkullFury(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            Timer.DelayCall(TimeSpan.FromSeconds(6.0), DoEffects);
        }
    }
}
