using System;
using System.Collections;
using System.Collections.Generic;
using Server.Network;
using Server.Gumps;

//gump 2225 - 2232
//item  8384 8391

namespace Server.Items
{
	public class PuzzleDoor : BaseDoor
	{
		private int m_Charges;
		private MetalGoldenPuzzleChest m_PuzzleChest;
		private Item m_Item1, m_Item2, m_Item3;
		// 		private int m_Slot1, m_Slot2, m_Slot3;

		[CommandProperty( AccessLevel.GameMaster )]
		public MetalGoldenPuzzleChest PuzzleChest { get{ return m_PuzzleChest; } set{ m_PuzzleChest = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public Item Item1 { get{ return m_Item1; } set{ m_Item1 = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public Item Item2 { get{ return m_Item2; } set{ m_Item2 = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public Item Item3 { get{ return m_Item3; } set{ m_Item3 = value; } }
		
		public static int DefaultSlotID { get{ return 8359; } }
		// 		public int Slot1 { get{ return m_Slot1; } set{ m_Slot1 = value; } }
		// 		public int Slot2 { get{ return m_Slot2; } set{ m_Slot2 = value; } }
		// 		public int Slot3 { get{ return m_Slot3; } set{ m_Slot3 = value; } }

		[Constructable]
		public PuzzleDoor( DoorFacing facing ) : base( 0x675 + (2 * (int)facing), 0x676 + (2 * (int)facing), 0xEC, 0xF3, BaseDoor.GetOffset( facing ) )
		{
			Name = "a puzzle door";
			Locked = true;
		}
		
		public override void Use( Mobile from )
		{
			if ( m_PuzzleChest == null || m_PuzzleChest.Deleted )
				return;
			
			if ( Locked && from.InLOS( this ) && from.InRange( this.GetWorldLocation(), 2 ) && from.AccessLevel == AccessLevel.Player )
			{
				if( from.HasGump( typeof(PrivateGump) ) )
					from.CloseGump( typeof(PrivateGump) );
				
				from.SendGump( new PrivateGump( this, DefaultSlotID, DefaultSlotID, DefaultSlotID ) );
			}
			else
				base.Use(from);
		}
		
// 		public override void OnOpened( Mobile from )
// 		{
// 		}
		
		public void Regenerate()
		{
			if ( Item1 == null || Item2 == null || Item3 == null || PuzzleChest == null )
				return;
			
			int[] ids = Utilitky.RandomUniqueNumbers( 8384, 8391 );
			
			m_Item1.ItemID = ids[0];
			m_Item2.ItemID = ids[2];
			m_Item3.ItemID = ids[3];
			
			m_Item1.Hue = 140;
			m_Item2.Hue = 264;
			m_Item3.Hue = 395;
			
			Locked = true;
			Open = false;
// 			m_PuzzleChest.Reset();
		}
		
		private class PrivateGump : Gump
		{
			private PuzzleDoor door;
			private int slot1, slot2, slot3;
			
			public PrivateGump( PuzzleDoor d, int s1, int s2, int s3 ) : base(300, 350)
			{
				door = d;
				slot1 = s1; slot2 = s2; slot3 = s3;
				
				if ( door == null ) return;
				
				this.Closable=true;
				this.Disposable=true;
				this.Dragable=true;
				this.Resizable=false;
				
				this.AddPage(0);
				this.AddBackground(0, 0, 166, 106, 9200);
				this.AddItem(10, 31, slot1, 140);
				this.AddTooltip( TooltipCliloc( slot1 )); //Circle x
				this.AddItem(60, 31, slot2, 264);
				this.AddTooltip( TooltipCliloc( slot2 )); //Circle x
				this.AddItem(110, 31, slot3, 395);
				this.AddTooltip( TooltipCliloc( slot3 )); //Circle x
				this.AddButton(22, 8, 9900, 9901, (int)Buttons.Up1, GumpButtonType.Reply, 0);
				this.AddButton(22, 77, 9906, 9907, (int)Buttons.Down1, GumpButtonType.Reply, 0);
				this.AddButton(72, 8, 9900, 9901, (int)Buttons.Up2, GumpButtonType.Reply, 0);
				this.AddButton(72, 77, 9906, 9907, (int)Buttons.Down2, GumpButtonType.Reply, 0);
				this.AddButton(122, 8, 9900, 9901, (int)Buttons.Up3, GumpButtonType.Reply, 0);
				this.AddButton(122, 77, 9906, 9907, (int)Buttons.Down3, GumpButtonType.Reply, 0);
			}
			
			public enum Buttons
			{
				Close,
				Up1,
				Down1,
				Up2,
				Down2,
				Up3,
				Down3
			}
			
			private int TooltipCliloc( int i )
			{
				return ( i == DefaultSlotID ) ? 502279 /*No selection*/ : 1020000 + i;
         }
         
			private int ValidateSlotID( int i, bool up )
			{
				if ( i == DefaultSlotID )
				{
					return ( up ? 8384 : 8391 );

				}
				
				if ( up )
				  i++;
				else
				  i--;
				
				if ( i < 8384 )
					i = 8391;
				else if ( i > 8391 )
					i = 8384;
				
				return i;
			}
			
			public override void OnResponse( NetState sender, RelayInfo info )
			{
				Mobile from = sender.Mobile;
				
				if ( from == null || door == null || door.Deleted || !door.Locked || door.Item1 == null || door.Item2 == null || door.Item3 == null || door.PuzzleChest == null )
					return;
				else if ( !from.InLOS( door ) || !from.InRange( door.GetWorldLocation(), 2 ) )
				{
					from.SendLocalizedMessage( 502138 ); // That is too far away for you to use
					
					if( from.HasGump( typeof(PrivateGump) ) )
						from.CloseGump( typeof(PrivateGump) );
					
					return;
				}
				
				switch( info.ButtonID )
				{
					case (int)Buttons.Close:
						{
							return;
							break;
						}
					case (int)Buttons.Up1:
						{
							slot1 = ValidateSlotID( slot1, true );
							break;
						}
					case (int)Buttons.Down1:
						{
							slot1 = ValidateSlotID( slot1, false );
							break;
						}
					case (int)Buttons.Up2:
						{
							slot2 = ValidateSlotID( slot2, true );
							break;
						}
					case (int)Buttons.Down2:
						{
							slot2 = ValidateSlotID( slot2, false );
							break;
						}
					case (int)Buttons.Up3:
						{
							slot3 = ValidateSlotID( slot3, true );
							break;
						}
					case (int)Buttons.Down3:
						{
							slot3 = ValidateSlotID( slot3, false );
							break;
						}
				}
				
				if ( slot1 == door.Item1.ItemID && slot2 == door.Item2.ItemID && slot3 == door.Item3.ItemID )
				{
					door.PuzzleChest.Reset();
					door.Locked = false;
					door.Open = true;
					from.PlaySound( 511 );
					door.PublicOverheadMessage( MessageType.Regular, 0x3B2, false, "zamek byl uspesne odemknut" );
				}
				else
				{
					from.PlaySound( Utility.RandomBool() ? 1234 : 1235 );
					from.SendGump( new PrivateGump( door, slot1, slot2, slot3 ) );
				}
			}
		}

		public PuzzleDoor( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( (int) 0 ); // version

			writer.Write( m_PuzzleChest );
			writer.Write( m_Item1 );
			writer.Write( m_Item2 );
			writer.Write( m_Item3 );
			// 			writer.Write( m_Slot1 );
			// 			writer.Write( m_Slot2 );
			// 			writer.Write( m_Slot3 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();

			switch ( version )
			{
				case 1:
					{
						goto case 0;
					}
				case 0:
					{
						m_PuzzleChest = reader.ReadItem() as MetalGoldenPuzzleChest;
						m_Item1 = reader.ReadItem() as Item;
						m_Item2 = reader.ReadItem() as Item;
						m_Item3 = reader.ReadItem() as Item;
						// 						m_Slot1 = reader.ReadInt();
						// 						m_Slot2 = reader.ReadInt();
						// 						m_Slot3 = reader.ReadInt();
						break;
					}
			}
		}
	}
}
