using System;
using Server;

namespace Server.Items
{
	public class Sprout : Item
	{
		[Constructable]
		public Sprout() : this( 1 )
		{
		}

		[Constructable]
		public Sprout( int amount ) : base( 3201 )
		{
			Stackable = true;
			Hue = 2963;
			Weight = 1.0;
			Amount = amount;
		}

		public Sprout( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}