using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a giant ice worm corpse" )]
	public class GiantIceWorm : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.ArmorIgnore;
					case 2: return WeaponAbility.ParalyzingBlow;
			}
		}
      
      [Constructable]
		public GiantIceWorm() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Body = 89;
			Name = "a giant ice worm";
			BaseSoundID = 0xDC;

			SetStr( 1201, 1225 );
			SetDex( 151, 170 );
			SetInt( 251, 282 );

			SetHits( 1010, 1170 );
			SetMana( 60, 65 );//from Hiryu
			SetStam( 170, 270 );//from hiryu

			SetDamage( 22, 28 );//hiryu damage
			
			SetDamageType( ResistanceType.Physical, 60 );
			SetDamageType( ResistanceType.Cold, 20 );
			SetDamageType( ResistanceType.Poison, 20 );
			
			SetResistance( ResistanceType.Physical, 45, 55 );//used 5 over and 5 under what stratics posted
			SetResistance( ResistanceType.Fire, 25, 35 );
			SetResistance( ResistanceType.Cold, 65, 75 );
			SetResistance( ResistanceType.Poison, 25, 35 );
			SetResistance( ResistanceType.Energy, 65, 75 );

			SetSkill( SkillName.Wrestling, 90.1, 96.8 );
			SetSkill( SkillName.Tactics, 90.3, 99.3 );
			SetSkill( SkillName.MagicResist, 75.3, 90.0 );
			SetSkill( SkillName.Anatomy, 65.5, 69.4 );
			SetSkill( SkillName.Healing, 72.2, 98.9 );
			SetSkill( SkillName.AnimalLore, 65.5, 69.4 );
			SetSkill( SkillName.Veterinary, 72.2, 98.9 );
			
			Fame = 4000;
			Karma = -1500;
			EmoteHue = Utility.RandomNeutralHue();

			VirtualArmor = 50;

			Tamable = true;
			ControlSlots = 3;
			MinTameSkill = 71.1;
		}

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override Poison HitPoison { get { return Poison.Deadly; } }
		public override FoodType FavoriteFood { get { return FoodType.Meat; } }
		public override bool CanAngerOnTame { get { return true; } }
		public override bool StatLossAfterTame{ get{ return true; } }
 		public override bool SubdueBeforeTame{ get{ return true; } } // Must be beaten into submission
      
		public override double GetControlChance( Mobile m )
		{
			if ( m.Skills[SkillName.AnimalTaming].Base < 71.1 )
			{
				m.SendMessage( "Nedokazes ovladat toto stvoreni." );
				return 0;
			}
			else
			{
				return 1.0;
			}
		}
      
		public override void OnThink()
		{
			base.OnThink();

         if ( Controlled )
            BandageSelf();

			if ( Loyalty < BaseCreature.MaxLoyalty && ControlMaster != null && ControlMaster.Map == Map )
			{
				Loyalty = BaseCreature.MaxLoyalty;
				Hunger = 20;
			}
		}
      
		public override bool OnBeforeDeath()
		{
         if ( 0.2 > Utility.RandomDouble() )
         {
            this.Emote( "* Cheating Death *" );
            this.Animate( 21, 6, 1, true, false, 0 );
            this.PlaySound( 94 );
            this.Hits = ( this.HitsMaxSeed / 3 );
            return false;
         }

			return base.OnBeforeDeath();
		}

		public GiantIceWorm( Serial serial ) : base ( serial )
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}