using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Server.Gumps
{
	public class BaseConfirmGump : Gump
	{
		public virtual int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
		public virtual int LabelNumber{ get{ return 1074975; } } // Are you sure you wish to select this?
		
		private enum Buttons
		{
			Close,
			Break,
			Confirm
		}
	
		public BaseConfirmGump() : base( 120, 50 )
		{			
        Closable=true;
        Disposable=true;
        Dragable=true;
        Resizable=false;
        AddPage(0);
        AddBackground(6, 7, 247, 181, 5054);
        AddImageTiled(13, 16, 233, 20, 0xA40);
        AddAlphaRegion(13, 16, 233, 20);
        AddHtmlLocalized( 13, 16, 233, 20, TitleNumber, 0x7D00, false, false );
        AddImageTiled(13, 39, 231, 90, 0xA40);
        AddAlphaRegion(13, 39, 231, 90);
        AddHtmlLocalized( 13, 39, 231, 90, LabelNumber, 0xFFFFFF, false, false );
        AddHtmlLocalized( 43, 139, 71, 16, 1074976, 0x000000, false, false );
        AddHtmlLocalized( 43, 162, 71, 16, 1074977, 0x000000, false, false );
        AddRadio(20, 137, 210, 211, false, (int)Buttons.Break);
        AddRadio(20, 160, 210, 211, true, (int)Buttons.Close);
        AddButton(177, 155, 247, 248, (int)Buttons.Confirm, GumpButtonType.Reply, 0);
		}
		
		public override void OnResponse( Server.Network.NetState state, RelayInfo info )
		{		
			if ( info.ButtonID == (int) Buttons.Confirm )
			{
				if ( info.IsSwitched( (int) Buttons.Break ) )
					Confirm( state.Mobile );
				else
					Refuse( state.Mobile );
			}
		}
		
		public virtual void Confirm( Mobile from )
		{		
		}
		
		public virtual void Refuse( Mobile from )
		{
		}
	}
}