
using System;

namespace Server.Items
{
[Furniture]
	[Flipable(0x2D0E,0x2D0F)]
	public class ArcanistStatue : Item
	{
		[Constructable]
		public ArcanistStatue() : base(0x2D0E)
		{
			Weight = 0.0;
		}

		public ArcanistStatue(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 4.0 )
				Weight = 1.0;
		}
	}
}

