
using System;

namespace Server.Items
{
	[Furniture]
	[Flipable( 0x2DEB, 0x2DEC, 0x2DED, 0x2DEE )]
	public class BigElvenChair : BaseFurniture
	{
		[Constructable]
		public BigElvenChair() : base(0x2DEB)
		{
			Weight = 0.0;
		}

		public BigElvenChair(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 6.0 )
				Weight = 20.0;
		}
	}
}

