using System;

namespace Server.Items
{
	[Furniture]
	[Flipable(0x2D4B, 0x2D4C)]
	public class ElvenBookStand : BaseFurniture
	{
		[Constructable]
		public ElvenBookStand() : base(0x2D4B)
		{
			Weight = 0.0;
		}

		public ElvenBookStand(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 8.0 )
				Weight = 10.0;
		}
	}
}

