using System;

namespace Server.Items
{
	
    [Furniture]
	[Flipable( 0x2DEF, 0x2DF0 )]
	public class ElvenBookshelf : BaseContainer
	{
		public override int DefaultGumpID{ get{ return 0x4D; } }
		public override int DefaultDropSound{ get{ return 0x42; } }

		public override Rectangle2D Bounds
		{
			get{ return new Rectangle2D( 80, 5, 140, 70 ); }
		}

		[Constructable]
		public ElvenBookshelf() : base( 0x2DEF )
		{
			Weight = 0.0;
		}

		public ElvenBookshelf( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	  }
	}

