using System;

namespace Server.Items
{
	public class ElvenBowStringer : Item
	{
		[Constructable]
		public ElvenBowStringer() : base( 0x2DD7 )
		{
			Weight = 0.0;
		}

		public ElvenBowStringer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight == 3.0 )
				Weight = 5.0;
		}
	}
}
