using System;
using System.Collections;
using Server;
using Server.Multis;
using Server.Network;

namespace Server.Items
{
[Furniture]
	[Flipable( 0x2D09, 0x2D0A )]
	public class ElvenDresser : BaseContainer
	{
		public override int DefaultGumpID{ get{ return 0x51; } }
		public override int DefaultDropSound{ get{ return 0x42; } }

		public override Rectangle2D Bounds
		{
			get{ return new Rectangle2D( 20, 10, 150, 90 ); }
		}

		[Constructable]
		public ElvenDresser() : base( 0x2D09 )
		{
			Weight = 0.0;
		}

		public ElvenDresser( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}

