using System;

namespace Server.Items
{
	[Furniture]
	[Flipable(0x2DDF, 0x2DE0)]
	public class ElvenLoveSeat : BaseFurniture
	{
		[Constructable]
		public ElvenLoveSeat() : base(0x2DDF)
		{
			Weight = 0.0;
		}

		public ElvenLoveSeat(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 6.0 )
				Weight = 1.0;
		}
	}
}

