
using System;

namespace Server.Items
{
[Furniture]
	[Flipable(0x2DDA,0x2DD9)]
	public class ElvenSpinningWheel : Item
	{
		[Constructable]
		public ElvenSpinningWheel() : base(0x2DDA)
		{
			Weight = 0.0;
		}

		public ElvenSpinningWheel(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 4.0 )
				Weight = 1.0;
		}
	}
}

