
using System;

namespace Server.Items
{
[Furniture]
	[Flipable(0x2DDB,0x2DDC)]
	public class ElvenStove : Item
	{
		[Constructable]
		public ElvenStove() : base(0x2DDB)
		{
			Weight = 0.0;
		}

		public ElvenStove(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 4.0 )
				Weight = 1.0;
		}
	}
}

