
using System;

namespace Server.Items
{
[Furniture]
	[Flipable(0x2D10,0x2D11)]
	public class SquirrelStatue : Item
	{
		[Constructable]
		public SquirrelStatue() : base(0x2D10)
		{
			Weight = 0.0;
		}

		public SquirrelStatue(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if ( Weight == 4.0 )
				Weight = 1.0;
		}
	}
}

