using System;

namespace Server.Items
{
	public class FruitBowl : Item
	{
		[Constructable]
		public FruitBowl() : base( 0x2D4F )
		{
			Weight = 0.0;
		}

		public FruitBowl( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight == 3.0 )
				Weight = 5.0;
		}
	}
}
