using System;
using Server;
using Server.Network;
using Server.Gumps;

namespace Server.Items
{
	public class RejuvinationAddonComponent : AddonComponent
	{
		public RejuvinationAddonComponent( int itemID ) : base( itemID )
		{
		}

		public RejuvinationAddonComponent( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( from.BeginAction( typeof( RejuvinationAddonComponent ) ) )
			{
				from.FixedEffect( 0x373A, 1, 16 );
				from.PlaySound( 0x1F2 );

				int random = Utility.Random( 1, 4 );

				if ( random == 1 || random == 4 )
				{
					from.Hits = from.HitsMax;
					SendLocalizedMessageTo( from, 500801 ); // A sense of warmth fills your body!
				}

				if ( random == 2 || random == 4 )
				{
					from.Mana = from.ManaMax;
					SendLocalizedMessageTo( from, 500802 ); // A feeling of power surges through your veins!
				}

				if ( random == 3 || random == 4 )
				{
					from.Stam = from.StamMax;
					SendLocalizedMessageTo( from, 500803 ); // You feel as though you've slept for days!
				}

				Timer.DelayCall( TimeSpan.FromHours( 2.0 ), new TimerStateCallback( ReleaseUseLock_Callback ), new object[]{ from, random } );
			}
		}

		public virtual void ReleaseUseLock_Callback( object state )
		{
			object[] states = (object[])state;

			Mobile from = (Mobile)states[0];
			int random = (int)states[1];

			from.EndAction( typeof( RejuvinationAddonComponent ) );

			if ( random == 4 )
			{
				from.Hits = from.HitsMax;
				from.Mana = from.ManaMax;
				from.Stam = from.StamMax;
				SendLocalizedMessageTo( from, 500807 ); // You feel completely rejuvinated!
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	/*
	public abstract class BaseRejuvinationAnkh : BaseAddon
	{
		public BaseRejuvinationAnkh()
		{
		}

		public override bool HandlesOnMovement{ get{ return true; } }

		private DateTime m_NextMessage;

		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			base.OnMovement( m, oldLocation );

			if ( m.Player && Utility.InRange( Location, m.Location, 3 ) && !Utility.InRange( Location, oldLocation, 3 ) )
			{
				if ( DateTime.Now >= m_NextMessage )
				{
					if ( Components.Count > 0 )
						((AddonComponent)Components[0]).SendLocalizedMessageTo( m, 1010061 ); // An overwhelming sense of peace fills you.

					m_NextMessage = DateTime.Now + TimeSpan.FromSeconds( 25.0 );
				}
			}
		}

		public BaseRejuvinationAnkh( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	public class RejuvinationAnkhWest : BaseRejuvinationAnkh
	{
		[Constructable]
		public RejuvinationAnkhWest()
		{
			AddComponent( new RejuvinationAddonComponent( 0x3 ), 0, 0, 0 );
			AddComponent( new RejuvinationAddonComponent( 0x2 ), 0, 1, 0 );
		}

		public RejuvinationAnkhWest( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	public class RejuvinationAnkhNorth : BaseRejuvinationAnkh
	{
		[Constructable]
		public RejuvinationAnkhNorth()
		{
			AddComponent( new RejuvinationAddonComponent( 0x4 ), 0, 0, 0 );
			AddComponent( new RejuvinationAddonComponent( 0x5 ), 1, 0, 0 );
		}

		public RejuvinationAnkhNorth( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	 */
	public class RejuvinationAnkhAddon : BaseAddon
	{
		public override bool HandlesOnMovement{ get{ return true; } }

		public override BaseAddonDeed Deed
		{
			get
			{
				RejuvinationAnkhDeed deed = new RejuvinationAnkhDeed();

				return deed;
			}
		}

		[Constructable]
		public RejuvinationAnkhAddon( bool east ) : base()
		{
			if ( east )
			{
				AddComponent( new RejuvinationAddonComponent( 0x1D98 ), 0, 0, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1D97 ), 0, 1, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CD6 ), 1, 0, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CD4 ), 1, 1, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CD0 ), 2, 0, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CCE ), 2, 1, 0 );
			}
			else
			{
				AddComponent( new RejuvinationAddonComponent( 0x1E5D ), 0, 0, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1E5C ), 1, 0, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CD2 ), 0, 1, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CD8 ), 1, 1, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CCD ), 0, 2, 0 );
				AddComponent( new RejuvinationAddonComponent( 0x1CCE ), 1, 2, 0 );
			}
		}

		public RejuvinationAnkhAddon( Serial serial ) : base( serial )
		{
		}

		private DateTime m_NextMessage;

		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			base.OnMovement( m, oldLocation );

			if ( m.Player && Utility.InRange( Location, m.Location, 3 ) && !Utility.InRange( Location, oldLocation, 3 ) )
			{
				if ( DateTime.Now >= m_NextMessage )
				{
					if ( Components.Count > 0 )
						((AddonComponent)Components[0]).SendLocalizedMessageTo( m, 1010061 ); // An overwhelming sense of peace fills you.

					m_NextMessage = DateTime.Now + TimeSpan.FromSeconds( 25.0 );
				}
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}

	public class RejuvinationAnkhDeed : BaseAddonDeed, IRewardOption
	{
		public override int LabelNumber{ get{ return 1027772; } } // Ankh Of Sacrifice

		public override BaseAddon Addon
		{
			get
			{
				RejuvinationAnkhAddon addon = new RejuvinationAnkhAddon( m_East );

				return addon;
			}
		}

		private bool m_East;

		[Constructable]
		public RejuvinationAnkhDeed() : base()
		{
			LootType = LootType.Blessed;
		}

		public RejuvinationAnkhDeed( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) )
			{
				from.CloseGump( typeof( RewardOptionGump ) );
				from.SendGump( new RewardOptionGump( this, 1076170 ) ); //Choose Direction
			}
			else
				from.SendLocalizedMessage( 1062334 ); // This item must be in your backpack to be used.
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}

		public void GetOptions( RewardOptionList list )
		{
			list.Add( 1, 1075386 ); // South
			list.Add( 2, 1075387 ); // East
		}

		public void OnOptionSelected( Mobile from, int option )
		{
			switch ( option )
			{
					case 1: m_East = false; break;
					case 2: m_East = true; break;
			}

			if ( !Deleted )
				base.OnDoubleClick( from );
		}
	}
}