using System;
using Server;
using Server.Network;
using Server.Items;
using System.Collections;

namespace Server.Items
{
    public class SawmillBlade : AddonComponent
    {
        [Constructable]
        public SawmillBlade() : base(4533)
        {
            Name = "nebezpecne vypadajici kotouc pily";
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (!from.InRange(this.GetWorldLocation(), 1))
            {
                from.SendMessage(89, "Jsi od kotouce v bezpecne vzdalenosti.");
            }
            else
            {
                from.SendMessage(89, "{0} jsi si prst !!!", (from.Female)?"Urizla":"Urizl" );
                Effects.PlaySound(from.Location, from.Map, 0x218);    // Plays the saw sound
                BeginBleed(from);
                // BLOOD
            }
        }

        // ****************************
        // *** BLOOD CODE FROM HERE ***
        // ****************************
        private static Hashtable m_BloodTable = new Hashtable();

        public static bool IsBleeding(Mobile m)
        {
            return m_BloodTable.Contains(m);
        }

        public static void BeginBleed(Mobile m)
        {
            Timer t = (Timer)m_BloodTable[m];

            if (t != null)
                t.Stop();

            t = new InternalTimer(m);
            m_BloodTable[m] = t;

            t.Start();
        }

        public static void DoBleed(Mobile m)
        {
            if (m.Alive)
            {
                m.PlaySound(0x133);

                Blood blood = new Blood();

                blood.ItemID = Utility.Random(0x122A, 5);

                blood.MoveToWorld(m.Location, m.Map);
            }
            else
            {
                EndBleed(m, false);
            }
        }

        public static void EndBleed(Mobile m, bool message)
        {
            Timer t = (Timer)m_BloodTable[m];

            if (t == null)
                return;

            t.Stop();
            m_BloodTable.Remove(m);

            if (message)
                m.SendLocalizedMessage(1060167); // The bleeding wounds have healed, you are no longer bleeding!
        }

        private class InternalTimer : Timer
        {
            private Mobile m_Mobile;
            private int m_Count;

            public InternalTimer(Mobile m) : base(TimeSpan.FromSeconds(2.0), TimeSpan.FromSeconds(2.0))
            {
                m_Mobile = m;
                Priority = TimerPriority.TwoFiftyMS;
            }

            protected override void OnTick()
            {
                DoBleed(m_Mobile);

                if (++m_Count == 5)
                    EndBleed(m_Mobile, true);
            }
        }

        // ***************************

        public SawmillBlade(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write(0); // Version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }

    public class SawmillSign : AddonComponent
    {
        private string m_SafetyWarning = "Upozorneni:";
        private string m_Resource = "drevo";

        [Constructable]
        public SawmillSign() : base(3026)
        {
            Name = "Cirkularka";
            Hue = 33;
        }

        public override void OnDoubleClick(Mobile from)
        {
            from.SendMessage(89, "Nikdy nesahej na kotouc pily!");
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);
            list.Add(1060661, "Pouze na \t{0}", m_Resource.ToString());
            list.Add(1060658, "{0}\tNikdy nedavejte prsty blizko kotouce pily.", m_SafetyWarning.ToString());
            list.Add(1060659, "{0}\tPouzivejte spravne ochrane pomucky.", m_SafetyWarning.ToString());
        }

        public SawmillSign(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write(0); // Version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }

    public class SawmillCrate : AddonComponent
    {
        [Constructable]
        public SawmillCrate() : base(3645)
		{
            Name = "Bedna na drevo";
		}

        public override void OnDoubleClick(Mobile from)
        {
            from.SendMessage(89, "Vlozte drevo do bedny");
        }

        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            int amounttocut = 0;

            if (!from.InRange(this.GetWorldLocation(), 1))
            {
                from.SendMessage(89, "Jsi od stroje prilis daleko.");
                return false;
            }
            else
            {
                if (dropped is BaseLog)
                {
                    if (dropped is Log)
                    {
                      Log yourlogs = (Log)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new Board(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is PineLog)
                    {
                      PineLog yourlogs = (PineLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new PineBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is CedarLog)
                    {
                      CedarLog yourlogs = (CedarLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new CedarBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is CherryLog)
                    {
                      CherryLog yourlogs = (CherryLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new CherryBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is MahoganyLog)
                    {
                      MahoganyLog yourlogs = (MahoganyLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new MahoganyBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is OakLog)
                    {
                      OakLog yourlogs = (OakLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new OakBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is AshLog)
                    {
                      AshLog yourlogs = (AshLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new AshBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is YewLog)
                    {
                      YewLog yourlogs = (YewLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new YewBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is HeartwoodLog)
                    {
                      HeartwoodLog yourlogs = (HeartwoodLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new HeartwoodBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is BloodwoodLog)
                    {
                      BloodwoodLog yourlogs = (BloodwoodLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new BloodwoodBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }
                    else if (dropped is FrostwoodLog)
                    {
                      FrostwoodLog yourlogs = (FrostwoodLog)dropped;
                      amounttocut = yourlogs.Amount;
                      Item spawn = new FrostwoodBoard(amounttocut);
                      from.SendMessage(89, "{0} jsi {1} {2}", (from.Female)?"Narezala":"Narezal",amounttocut, spawn.Name );
                      spawn.MoveToWorld(new Point3D(this.X, this.Y-3, this.Z+3), this.Map);
                    }

                    dropped.Delete();
                    Effects.PlaySound(from.Location, from.Map, 0x218);  // Plays the saw sound
                    return true;
                }

                from.SendMessage(89, "Pila reze pouze kulany dreva.");
                return false;
            }
            return false;
        }
        public SawmillCrate(Serial serial) : base(serial)
		{
		}

        public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
    }

	public class SawmillAddon : BaseAddon
	{
        public override BaseAddonDeed Deed
        { get { return new SawmillAddonDeed(); } }

        [Constructable]
        public SawmillAddon()
        {
            // base
            AddComponent(new AddonComponent(2328), 0, 0, 0);
            AddComponent(new AddonComponent(2328), 0, -3, 0);
            AddComponent(new AddonComponent(1872), 0, -1, 0);
            AddComponent(new AddonComponent(1872), 0, -2, 0);

            // platforms
            AddComponent(new AddonComponent(1981), 0, -1, 5);
            AddComponent(new AddonComponent(1981), 0, -2, 5);
            AddComponent(new AddonComponent(1981), 0, -3, 1);

            // blade
            AddComponent(new SawmillBlade(), 0, -1, 4);

            // sign
            AddComponent(new SawmillSign(), 1, -1, -6);

            // crate
            AddComponent(new SawmillCrate(), 0, 0, 0);
        }

        public SawmillAddon(Serial serial) : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}	
	}

	public class SawmillAddonDeed : BaseAddonDeed
	{
        public override BaseAddon Addon
        { get { return new SawmillAddon(); } }

        [Constructable]
		public SawmillAddonDeed()
		{
			Name = "Cirkularka";
		}

        public SawmillAddonDeed(Serial serial) : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}