//Ber 2006

using System;
using Server;
using Server.Items;
using Server.Network;

namespace Server.Items
{
    public class CreepyPortraitW : AddonComponent
	{
		private InternalTimer m_Timer;
		public static TimeSpan AnimDelay = TimeSpan.FromSeconds( 1.0 ); //the delay between animation is 1 seconds
		public DateTime m_NextAnim;

		[Constructable]
		public CreepyPortraitW() : base( 10861 )
		{
			Name = "Creepy Portrait";
			Movable = true;
		}

		public CreepyPortraitW( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile m )
		{
			if ( m.InRange( this, 3 ) ) 
			{
				switch ( ItemID ) 
				{ 
					//do swap or animation here 
					case 10861: //1
						this.ItemID=10862;
						Talk( m ); 
						break;
					case 10862: //2
						this.ItemID=10863;
						Talk( m ); 
						break;
					case 10863: //3
						this.ItemID=10864; 
						Talk( m );
						break;
					case 10864: //4
						this.ItemID=10861;
						Talk( m );
						break;
					default: break; 
				}
			}
			else
			{
				m.LocalOverheadMessage( MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that
			}
		}
		
		public void Talk( Mobile m )
		{
			m.PlaySound( Utility.RandomList( 0x569, 0x567, 0x206, 0x5CE ));
		}

		public override bool HandlesOnMovement{ get{ return true; } }

		public override void OnMovement( Mobile m, Point3D oldLocation ) 
		{ 
			if ( DateTime.Now >= m_NextAnim && m.InRange( this, 4 ) && !m.Hidden ) // check if it's time to animate & mobile in range & in los.
			{
				m_NextAnim = DateTime.Now + AnimDelay; // set next animation time

				switch ( ItemID ) 
				{ 
					//do swap or animation here 
					case 10861: //1
						this.ItemID=10862;
						new InternalTimer( this, m ).Start();
						Talk( m );
						break;
					case 10862: //2
						this.ItemID=10863; 
						break;
					case 10863: //3
						this.ItemID=10864; 
						break;
					case 10864: //4
						this.ItemID=10861; 
						break;
					default: break; 
				}
			}
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.WriteEncodedInt( 0 );
		}
        
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadEncodedInt();
		}

		public class InternalTimer : Timer
		{
			private int m_Count = 5;
			private CreepyPortraitW m_CreepyPortraitW;
			private Mobile m_From;
	
			public InternalTimer( CreepyPortraitW creepyportraitw, Mobile from ) : base( TimeSpan.FromSeconds( 1.0 ), TimeSpan.FromSeconds( 1.0 ) )
			{
				m_CreepyPortraitW = creepyportraitw;
				m_From = from;
            Priority = TimerPriority.OneSecond;
			}
						// added
			protected override void OnTick() 
			{
				m_Count--;
	
				if ( m_Count == ( 4 ) )
				{
					m_CreepyPortraitW.ItemID=10861;
				}
				if ( m_Count == ( 3 ) )
				{
					m_CreepyPortraitW.ItemID=10862;
				}
				if ( m_Count == ( 2 ) )
				{
					m_CreepyPortraitW.ItemID=10863;
				}
				if ( m_Count == ( 1 ) )
				{
					m_CreepyPortraitW.ItemID=10864; 
				}
				if ( m_Count == 0 )
				{
					Stop();
				}

				if ( m_From.NetState == null )
				{
					Stop();
				}
			}
			//end add
		}
	}
			
	public class CreepyPortraitWAddon : BaseAddon
	{
	    public override BaseAddonDeed Deed{ get{ return new CreepyPortraitWDeed(); } }
		
		[Constructable]
		public CreepyPortraitWAddon()
		{
		  Name = "Creepy Portrait West";
			Weight = 2.0;
			
			AddComponent( new CreepyPortraitW(), 0, 0, 0 );
		}

		public CreepyPortraitWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
        }		
	}

	public class CreepyPortraitWDeed : BaseAddonDeed
	{
		public override BaseAddon Addon{ get{ return new CreepyPortraitWAddon(); } }

		[Constructable]
		public CreepyPortraitWDeed()
		{
		    Name = "Creepy Portrait West";
		}

		public CreepyPortraitWDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
    }
	
}