using System;
using Server.Network;

namespace Server.Items
{
	public class PixieTalk
	{
	  public static void Talk( Mobile m, Item pixi )
	  {
			if ( m.InRange( pixi, 3 ) && m.InLOS( pixi ))
            m.PlaySound( Utility.RandomList( 0x554, 0x555, 0x556, 0x557, 0x558, 0x559, 0x55A, 0x55B, 0x55C, 0x55D, 0x55E, 0x55F, 0x560, 0x561, 0x562, 0x563, 0x564 ));
			else
				m.LocalOverheadMessage( MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
	  }
	}
   
   [FlipableAttribute( 0x2A75, 0x2A76 )] 
	public class BlueMountedPixie : Item
	{
		[Constructable]
		public BlueMountedPixie() : base( 0x2A75 )
		{
			Name = "Mounted Pixie";
		}
		
		public override void OnDoubleClick( Mobile m )
		{
		    PixieTalk.Talk( m, (Item)this );
		}

		public BlueMountedPixie( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x2A71, 0x2A72 )] 
	public class GreenMountedPixie : Item
	{
		[Constructable]
		public GreenMountedPixie() : base( 0x2A71 )
		{
			Name = "Mounted Pixie";
		}
		
		public override void OnDoubleClick( Mobile m )
		{
		    PixieTalk.Talk( m, (Item)this );
		}

		public GreenMountedPixie( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x2A77, 0x2A78 )] 
	public class GreenMountedPixie2 : Item
	{
		[Constructable]
		public GreenMountedPixie2() : base( 0x2A77 )
		{
			Name = "Mounted Pixie";
		}
		
		public override void OnDoubleClick( Mobile m )
		{
		    PixieTalk.Talk( m, (Item)this );
		}

		public GreenMountedPixie2( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x2A73, 0x2A74 )] 
	public class OrangeMountedPixie : Item
	{
		[Constructable]
		public OrangeMountedPixie() : base( 0x2A73 )
		{
			Name = "Mounted Pixie";
		}
		
		public override void OnDoubleClick( Mobile m )
		{
		    PixieTalk.Talk( m, (Item)this );
		}

		public OrangeMountedPixie( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x2A79, 0x2A7A )] 
	public class PinkMountedPixie : Item
	{
		[Constructable]
		public PinkMountedPixie() : base( 0x2A79 )
		{
			Name = "Mounted Pixie";
		}
		
		public override void OnDoubleClick( Mobile m )
		{
		    PixieTalk.Talk( m, (Item)this );
		}

		public PinkMountedPixie( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

}
