using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class StoneCoffinEastAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new StoneCoffinEastAddonDeed();
			}
		}

		[ Constructable ]
		public StoneCoffinEastAddon()
		{
			AddComponent( new AddonComponent( 12363 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 12362 ), 1, 0, 0 );
// 			AddonComponent ac = null;

		}

		public StoneCoffinEastAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class StoneCoffinEastAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new StoneCoffinEastAddon();
			}
		}

		[Constructable]
		public StoneCoffinEastAddonDeed()
		{
			Name = "Stone Coffin";
		}

		public StoneCoffinEastAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}