using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class StoneCoffinSouthAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new StoneCoffinSouthAddonDeed();
			}
		}

		[ Constructable ]
		public StoneCoffinSouthAddon()
		{
			AddComponent( new AddonComponent( 12360 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 12361 ), 0, 0, 0 );
// 			AddonComponent ac = null;

		}

		public StoneCoffinSouthAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class StoneCoffinSouthAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new StoneCoffinSouthAddon();
			}
		}

		[Constructable]
		public StoneCoffinSouthAddonDeed()
		{
			Name = "Stone Coffin";
		}

		public StoneCoffinSouthAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}