using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Engines.Quests.Haven;
using Server.Engines.VeteranRewards;

namespace Server.Items
{
	public class CannonAddonComponent : AddonComponent
	{
		public override int LabelNumber{ get{ return 1076157; } } // Decorative Cannon

		public CannonAddonComponent( int itemID ) : base( itemID )
		{
			LootType = LootType.Blessed;
		}

		public CannonAddonComponent( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	public class CannonAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				CannonDeed deed = new CannonDeed();
				deed.IsRewardItem = m_IsRewardItem;

				return deed;
			}
		}
		
		private CannonDirection m_CannonDirection;
		private bool m_IsRewardItem;

		[CommandProperty( AccessLevel.GameMaster )]
		public CannonDirection CannonDirection
		{
			get{ return m_CannonDirection; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool IsRewardItem
		{
			get{ return m_IsRewardItem; }
			set
			{
				m_IsRewardItem = value;
				
				foreach ( AddonComponent c in Components )
					c.InvalidateProperties();
			}
		}

		[Constructable]
		public CannonAddon( CannonDirection direction )
		{
			m_CannonDirection = direction;

			switch ( direction )
			{
				case CannonDirection.North:
					{
						AddComponent( new CannonAddonComponent( 0xE8D ), 0, 0, 0 );
						AddComponent( new CannonAddonComponent( 0xE8C ), 0, 1, 0 );
						AddComponent( new CannonAddonComponent( 0xE8B ), 0, 2, 0 );

						break;
					}
				case CannonDirection.East:
					{
						AddComponent( new CannonAddonComponent( 0xE96 ), 0, 0, 0 );
						AddComponent( new CannonAddonComponent( 0xE95 ), -1, 0, 0 );
						AddComponent( new CannonAddonComponent( 0xE94 ), -2, 0, 0 );

						break;
					}
				case CannonDirection.South:
					{
						AddComponent( new CannonAddonComponent( 0xE91 ), 0, 0, 0 );
						AddComponent( new CannonAddonComponent( 0xE92 ), 0, -1, 0 );
						AddComponent( new CannonAddonComponent( 0xE93 ), 0, -2, 0 );

						break;
					}
				default:
					{
						AddComponent( new CannonAddonComponent( 0xE8E ), 0, 0, 0 );
						AddComponent( new CannonAddonComponent( 0xE8F ), 1, 0, 0 );
						AddComponent( new CannonAddonComponent( 0xE90 ), 2, 0, 0 );

						break;
					}
			}
		}

		public CannonAddon( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version

			writer.Write( (int) m_CannonDirection );
			writer.Write( (bool) m_IsRewardItem );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();

			m_CannonDirection = (CannonDirection) reader.ReadInt();
			m_IsRewardItem = reader.ReadBool();
		}
	}
	
	public class CannonDeed : BaseAddonDeed, IRewardItem, IRewardOption
	{
		public override int LabelNumber{ get{ return 1076195; } } // A deed for a cannon
		
		public override BaseAddon Addon
		{
			get
			{
				CannonAddon addon = new CannonAddon( m_Direction );
				addon.IsRewardItem = m_IsRewardItem;

				return addon;
			}
		}

		private CannonDirection m_Direction;
		private bool m_IsRewardItem;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool IsRewardItem
		{
			get{ return m_IsRewardItem; }
			set{ m_IsRewardItem = value; InvalidateProperties(); }
		}
		
		[Constructable]
		public CannonDeed() : base()
		{
			LootType = LootType.Blessed;
		}

		public CannonDeed( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
			if ( m_IsRewardItem )
				list.Add( 1076223 ); // 7th Year Veteran Reward
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( m_IsRewardItem && !RewardSystem.CheckIsUsableBy( from, this, null ) )
				return;
			
			if ( IsChildOf( from.Backpack ) )
			{
				from.CloseGump( typeof( RewardOptionGump ) );
				from.SendGump( new RewardOptionGump( this, 1076170 ) ); //Choose Direction
			}
			else
				from.SendLocalizedMessage( 1042038 ); // You must have the object in your backpack to use it.
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
			
			writer.Write( (bool) m_IsRewardItem );
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
			
			m_IsRewardItem = reader.ReadBool();
		}

		public void GetOptions( RewardOptionList list )
		{
			list.Add( (int) CannonDirection.South, 1075386 ); // South
			list.Add( (int) CannonDirection.East, 1075387 ); // East
			list.Add( (int) CannonDirection.North, 1075389 ); // North
			list.Add( (int) CannonDirection.West, 1075390 ); // West
		}

		public void OnOptionSelected( Mobile from, int option )
		{
			m_Direction = (CannonDirection) option;

			if ( !Deleted )
				base.OnDoubleClick( from );
		}
	}
}
