// Scripted by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class DishingStumpAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new DishingStumpAddonDeed();
			}
		}

		[ Constructable ]
		public DishingStumpAddon()
		{
			AddComponent( new AddonComponent( 6245 ), 0, 0, 0 );
			AddonComponent ac = null;
			ac = new AddonComponent( 6245 );
			AddComponent( ac, 0, 0, 0 );

		}

		public DishingStumpAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class DishingStumpAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new DishingStumpAddon();
			}
		}

		[Constructable]
		public DishingStumpAddonDeed()
		{
			Name = "DishingStump";
		}

		public DishingStumpAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}