using System;
using Server;

namespace Server.Items
{
   public class FruitBasketD : BaseAddon
   {
      public override BaseAddonDeed Deed{ get{ return new FruitBasketDDeed(); } }

      [Constructable]
      public FruitBasketD()
      {

         AddComponent( new AddonComponent( 0x0993 ), 0, 0, 0 );

      }

      public FruitBasketD( Serial serial ) : base( serial )
      {
      }

	public override void OnDoubleClick( Mobile from )
	{
		Mobile m_Placer = from; 

		if ( from.InRange( this.GetWorldLocation(), 1 ) )
		{
				if ( m_Placer == null || from == m_Placer || from.AccessLevel >= AccessLevel.GameMaster )
				{
					from.AddToBackpack( new FruitBasketDDeed() );

					this.Delete();

					from.SendMessage( "A deed for the item has been placed in your backpack." );
				}
				else
				{
					from.SendMessage( "You cannot redeed this item." ); // You cannot take this tree down.
				}
			}
			else
			{
				from.SendLocalizedMessage( 500446 ); // That is too far away.
			}
		}

      public override void Serialize( GenericWriter writer )
      {
         base.Serialize( writer );

         writer.Write( (int) 0 ); // version
      }

      public override void Deserialize( GenericReader reader )
      {
         base.Deserialize( reader );

         int version = reader.ReadInt();
      }
   }

   public class FruitBasketDDeed : BaseAddonDeed
   {
      public override BaseAddon Addon{ get{ return new FruitBasketD(); } }
      
      [Constructable]
      public FruitBasketDDeed()
      {
	Name = "Fruit Basket";
      }

      public FruitBasketDDeed( Serial serial ) : base( serial )
      {

      }

      public override void Serialize( GenericWriter writer )
      {
         base.Serialize( writer );

         writer.Write( (int) 0 ); // version
      }

      public override void Deserialize( GenericReader reader )
      {
         base.Deserialize( reader );

         int version = reader.ReadInt();
      }
   }

   
}