// Scripted by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HorseBardingNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HorseBardingNAddonDeed();
			}
		}

		[ Constructable ]
		public HorseBardingNAddon()
		{
			AddComponent( new AddonComponent( 4983 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 4982 ), 0, 0, 0 );
			AddonComponent ac = null;
			ac = new AddonComponent( 4982 );
			AddComponent( ac, 0, 0, 0 );
			ac = new AddonComponent( 4983 );
			AddComponent( ac, 1, 0, 0 );

		}

		public HorseBardingNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HorseBardingNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HorseBardingNAddon();
			}
		}

		[Constructable]
		public HorseBardingNAddonDeed()
		{
			Name = "HorseBardingN";
		}

		public HorseBardingNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}