// Scripted by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HorseBardingWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HorseBardingWAddonDeed();
			}
		}

		[ Constructable ]
		public HorseBardingWAddon()
		{
			AddComponent( new AddonComponent( 4984 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 4985 ), 0, 0, 0 );
			AddonComponent ac = null;
			ac = new AddonComponent( 4984 );
			AddComponent( ac, 0, 1, 0 );
			ac = new AddonComponent( 4985 );
			AddComponent( ac, 0, 0, 0 );

		}

		public HorseBardingWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HorseBardingWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HorseBardingWAddon();
			}
		}

		[Constructable]
		public HorseBardingWAddonDeed()
		{
			Name = "HorseBardingW";
		}

		public HorseBardingWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}