// Scripted by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class OreCartNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new OreCartNAddonDeed();
			}
		}

		[ Constructable ]
		public OreCartNAddon()
		{
			AddComponent( new AddonComponent( 6791 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 6792 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 6795 ), -1, 0, 0 );
			AddonComponent ac = null;
			ac = new AddonComponent( 6791 );
			AddComponent( ac, 1, 0, 0 );
			ac = new AddonComponent( 6792 );
			AddComponent( ac, 0, 0, 0 );
			ac = new AddonComponent( 6795 );
			AddComponent( ac, -1, 0, 0 );

		}

		public OreCartNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class OreCartNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new OreCartNAddon();
			}
		}

		[Constructable]
		public OreCartNAddonDeed()
		{
			Name = "OreCartN";
		}

		public OreCartNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}