// Scripted by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class OreCartWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new OreCartWAddonDeed();
			}
		}

		[ Constructable ]
		public OreCartWAddon()
		{
			AddComponent( new AddonComponent( 6790 ), 0, -1, 0 );
			AddComponent( new AddonComponent( 6786 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 6787 ), 0, 0, 0 );
			AddonComponent ac = null;
			ac = new AddonComponent( 6787 );
			AddComponent( ac, 0, 0, 0 );
			ac = new AddonComponent( 6790 );
			AddComponent( ac, 0, -1, 0 );

		}

		public OreCartWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class OreCartWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new OreCartWAddon();
			}
		}

		[Constructable]
		public OreCartWAddonDeed()
		{
			Name = "OreCartW";
		}

		public OreCartWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}