// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class ValorNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new ValorNAddonDeed();
			}
		}

		[ Constructable ]
		public ValorNAddon()
		{
			AddComponent( new AddonComponent( 5307 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5308 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5309 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5310 ), 1, 0, 0 );
		}

		public ValorNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class ValorNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new ValorNAddon();
			}
		}

		[Constructable]
		public ValorNAddonDeed()
		{
			Name = "Valor North";
		}

		public ValorNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}