// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class ChaosAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new ChaosAddonDeed();
			}
		}

		[ Constructable ]
		public ChaosAddon()
		{
			AddComponent( new AddonComponent( 5348 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5349 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5350 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5347 ), 0, 0, 0 );
		}

		public ChaosAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class ChaosAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new ChaosAddon();
			}
		}

		[Constructable]
		public ChaosAddonDeed()
		{
			Name = "Chaos";
		}

		public ChaosAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}