// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class CompassionNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new CompassionNAddonDeed();
			}
		}

		[ Constructable ]
		public CompassionNAddon()
		{
			AddComponent( new AddonComponent( 5293 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5292 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5291 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5294 ), 1, 0, 0 );
		}

		public CompassionNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class CompassionNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new CompassionNAddon();
			}
		}

		[Constructable]
		public CompassionNAddonDeed()
		{
			Name = "Compassion North";
		}

		public CompassionNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}