// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class CompassionWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new CompassionWAddonDeed();
			}
		}

		[ Constructable ]
		public CompassionWAddon()
		{
			AddComponent( new AddonComponent( 5287 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5288 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5289 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5290 ), 1, 0, 0 );
		}

		public CompassionWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class CompassionWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new CompassionWAddon();
			}
		}

		[Constructable]
		public CompassionWAddonDeed()
		{
			Name = "Compassion West";
		}

		public CompassionWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}