// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HonestyNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HonestyNAddonDeed();
			}
		}

		[ Constructable ]
		public HonestyNAddon()
		{
			AddComponent( new AddonComponent( 5284 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5283 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5286 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5285 ), 1, 1, 0 );
		}

		public HonestyNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HonestyNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HonestyNAddon();
			}
		}

		[Constructable]
		public HonestyNAddonDeed()
		{
			Name = "Honesty North";
		}

		public HonestyNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}