// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HonestyWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HonestyWAddonDeed();
			}
		}

		[ Constructable ]
		public HonestyWAddon()
		{
			AddComponent( new AddonComponent( 5279 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5282 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5281 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5280 ), 0, 1, 0 );
		}

		public HonestyWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HonestyWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HonestyWAddon();
			}
		}

		[Constructable]
		public HonestyWAddonDeed()
		{
			Name = "Honesty West";
		}

		public HonestyWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}