// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HonorNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HonorNAddonDeed();
			}
		}

		[ Constructable ]
		public HonorNAddon()
		{
			AddComponent( new AddonComponent( 5325 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5326 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5323 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5324 ), 0, 1, 0 );
		}

		public HonorNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HonorNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HonorNAddon();
			}
		}

		[Constructable]
		public HonorNAddonDeed()
		{
			Name = "Honor North";
		}

		public HonorNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}